/*
 * Decompiled with CFR 0.152.
 */
package me.hyfe.simplespigot.text.json;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.Validate;

public class ArrayWrapper<E> {
    private E[] elements;

    public ArrayWrapper(E ... EArray) {
        this.setArray(EArray);
    }

    public static <T> T[] toArray(Iterable<? extends T> iterable, Class<T> clazz) {
        Object[] objectArray;
        int n = -1;
        if (iterable instanceof Collection) {
            objectArray = (Collection)iterable;
            n = objectArray.size();
        }
        if (n < 0) {
            n = 0;
            for (Object e : iterable) {
                ++n;
            }
        }
        objectArray = (Object[])Array.newInstance(clazz, n);
        int n2 = 0;
        for (T t : iterable) {
            objectArray[n2++] = t;
        }
        return objectArray;
    }

    public E[] getArray() {
        return this.elements;
    }

    public void setArray(E[] EArray) {
        Validate.notNull(EArray, (String)"The array must not be null.");
        this.elements = EArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ArrayWrapper)) {
            return false;
        }
        return Arrays.equals(this.elements, ((ArrayWrapper)object).elements);
    }

    public int hashCode() {
        return Arrays.hashCode(this.elements);
    }
}

