/*
 * Decompiled with CFR 0.152.
 */
package me.hyfe.simplespigot.text.json;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.stream.JsonWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import me.hyfe.simplespigot.text.json.JsonMessage;
import me.hyfe.simplespigot.text.json.JsonRepresentedObject;
import me.hyfe.simplespigot.text.json.JsonString;
import me.hyfe.simplespigot.text.json.TextualComponent;
import org.bukkit.ChatColor;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

public class MessagePart
implements JsonRepresentedObject,
ConfigurationSerializable,
Cloneable {
    static final BiMap<ChatColor, String> stylesToNames;
    private ChatColor color;
    private String insertionData;
    private List<ChatColor> styles;
    private String clickActionName;
    private String clickActionData;
    private String hoverActionName;
    private TextualComponent text;
    private JsonRepresentedObject hoverActionData;
    private List<JsonRepresentedObject> translationReplacements;

    MessagePart(TextualComponent textualComponent) {
        this.text = textualComponent;
        this.color = ChatColor.WHITE;
        this.styles = Lists.newArrayList();
        this.translationReplacements = Lists.newArrayList();
    }

    MessagePart() {
        this(null);
    }

    public static MessagePart deserialize(Map<String, Object> map) {
        MessagePart messagePart = new MessagePart((TextualComponent)map.get("text"));
        messagePart.setStyles((List)map.get("styles"));
        messagePart.setColor(ChatColor.getByChar((String)map.get("color").toString()));
        messagePart.setHoverActionName((String)map.get("hoverActionName"));
        messagePart.setHoverActionData((JsonRepresentedObject)map.get("hoverActionData"));
        messagePart.setClickActionName((String)map.get("clickActionName"));
        messagePart.setClickActionData((String)map.get("clickActionData"));
        messagePart.setInsertionData((String)map.get("insertion"));
        messagePart.setTranslationReplacements((List)map.get("translationReplacements"));
        return messagePart;
    }

    public ChatColor getColor() {
        return this.color;
    }

    public void setColor(ChatColor chatColor) {
        this.color = chatColor;
    }

    public String getInsertionData() {
        return this.insertionData;
    }

    public void setInsertionData(String string) {
        this.insertionData = string;
    }

    public List<ChatColor> getStyles() {
        return this.styles;
    }

    public void setStyles(List<ChatColor> list) {
        this.styles = list;
    }

    public String getClickActionName() {
        return this.clickActionName;
    }

    public void setClickActionName(String string) {
        this.clickActionName = string;
    }

    public String getClickActionData() {
        return this.clickActionData;
    }

    public void setClickActionData(String string) {
        this.clickActionData = string;
    }

    public String getHoverActionName() {
        return this.hoverActionName;
    }

    public void setHoverActionName(String string) {
        this.hoverActionName = string;
    }

    public TextualComponent getText() {
        return this.text;
    }

    public void setText(TextualComponent textualComponent) {
        this.text = textualComponent;
    }

    public JsonRepresentedObject getHoverActionData() {
        return this.hoverActionData;
    }

    public void setHoverActionData(JsonRepresentedObject jsonRepresentedObject) {
        this.hoverActionData = jsonRepresentedObject;
    }

    public List<JsonRepresentedObject> getTranslationReplacements() {
        return this.translationReplacements;
    }

    public void setTranslationReplacements(List<JsonRepresentedObject> list) {
        this.translationReplacements = list;
    }

    public boolean hasText() {
        return Objects.nonNull(this.text);
    }

    public MessagePart clone() {
        MessagePart messagePart = (MessagePart)super.clone();
        messagePart.setStyles(Lists.newArrayList(this.styles));
        if (this.hoverActionData instanceof JsonString) {
            messagePart.setHoverActionData(new JsonString(((JsonString)this.hoverActionData).getValue()));
        } else if (this.hoverActionData instanceof JsonMessage) {
            messagePart.setHoverActionData(((JsonMessage)this.hoverActionData).clone());
        }
        messagePart.setTranslationReplacements(Lists.newArrayList(this.translationReplacements));
        return messagePart;
    }

    @Override
    public void writeJson(JsonWriter jsonWriter) {
        jsonWriter.beginObject();
        this.text.writeJson(jsonWriter);
        jsonWriter.name("color").value(this.color.name().toLowerCase());
        for (ChatColor object : this.styles) {
            jsonWriter.name((String)stylesToNames.get((Object)object)).value(true);
        }
        if (this.clickActionName != null && this.clickActionData != null) {
            jsonWriter.name("clickEvent").beginObject().name("action").value(this.clickActionName).name("value").value(this.clickActionData).endObject();
        }
        if (this.hoverActionName != null && this.hoverActionData != null) {
            jsonWriter.name("hoverEvent").beginObject().name("action").value(this.hoverActionName).name("value");
            this.hoverActionData.writeJson(jsonWriter);
            jsonWriter.endObject();
        }
        if (this.insertionData != null) {
            jsonWriter.name("insertion").value(this.insertionData);
        }
        if (this.translationReplacements.size() > 0 && TextualComponent.isTranslatableText(this.text)) {
            jsonWriter.name("with").beginArray();
            for (JsonRepresentedObject jsonRepresentedObject : this.translationReplacements) {
                jsonRepresentedObject.writeJson(jsonWriter);
            }
            jsonWriter.endArray();
        }
        jsonWriter.endObject();
    }

    public Map<String, Object> serialize() {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("text", this.text);
        hashMap.put("styles", this.styles);
        hashMap.put("color", Character.valueOf(this.color.getChar()));
        hashMap.put("hoverActionName", this.hoverActionName);
        hashMap.put("hoverActionData", this.hoverActionData);
        hashMap.put("clickActionName", this.clickActionName);
        hashMap.put("clickActionData", this.clickActionData);
        hashMap.put("insertion", this.insertionData);
        hashMap.put("translationReplacements", this.translationReplacements);
        return hashMap;
    }

    static {
        ConfigurationSerialization.registerClass(MessagePart.class);
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        block4: for (ChatColor chatColor : ChatColor.values()) {
            if (!chatColor.isFormat()) continue;
            Consumer<String> consumer = string -> builder.put((Object)chatColor, string);
            switch (chatColor) {
                case MAGIC: {
                    consumer.accept("obfuscated");
                    continue block4;
                }
                case UNDERLINE: {
                    consumer.accept("underlined");
                    continue block4;
                }
                default: {
                    consumer.accept(chatColor.name().toLowerCase());
                }
            }
        }
        stylesToNames = builder.build();
    }
}

