/*
 * Decompiled with CFR 0.152.
 */
package me.hyfe.simplespigot.text.replacer;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class Replacer {
    private final Map<String, Object> variables = Maps.newHashMap();
    private final Map<String, Supplier<Object>> retrievableVariables = Maps.newHashMap();
    private OfflinePlayer player;
    private boolean usePlaceholderApi;

    public static String to(String string, UnaryOperator<Replacer> unaryOperator) {
        return ((Replacer)unaryOperator.apply(new Replacer())).applyTo(string);
    }

    public static Replacer of(Map<String, String> map) {
        Replacer replacer = new Replacer();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            replacer.set(entry.getKey(), entry.getValue());
        }
        return replacer;
    }

    public Replacer set(String string, Object object) {
        this.variables.put("%" + string + "%", object);
        return this;
    }

    public Replacer set(String string, Supplier<Object> supplier) {
        this.retrievableVariables.put("%" + string + "%", supplier);
        return this;
    }

    public Replacer tryAddPapi(OfflinePlayer offlinePlayer) {
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.player = offlinePlayer;
            this.usePlaceholderApi = true;
        }
        return this;
    }

    public String applyTo(String string) {
        String string2 = string;
        for (Map.Entry<String, Object> entry : this.variables.entrySet()) {
            string2 = string2.replace(entry.getKey(), Objects.toString(entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.retrievableVariables.entrySet()) {
            if (!string2.contains(entry.getKey())) continue;
            string2 = string2.replace(entry.getKey(), Objects.toString(((Supplier)entry.getValue()).get()));
        }
        if (this.usePlaceholderApi) {
            return PlaceholderAPI.setPlaceholders((OfflinePlayer)this.player, (String)string2);
        }
        return string2;
    }
}

