/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.actions.external;

import de.marcely.bedwars.api.event.arena.ArenaBedBreakEvent;
import de.marcely.bedwars.api.event.arena.TeamEliminateEvent;
import de.marcely.bedwars.api.event.player.PlayerBuyInShopEvent;
import de.marcely.bedwars.api.event.player.PlayerJoinArenaEvent;
import de.marcely.bedwars.api.event.player.PlayerKillPlayerEvent;
import de.marcely.bedwars.api.event.player.PlayerStatChangeEvent;
import java.util.UUID;
import net.advancedplugins.bp.impl.actions.external.executor.ActionQuestExecutor;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.java.JavaPlugin;

public class MBedwarsQuests
extends ActionQuestExecutor {
    public MBedwarsQuests(JavaPlugin javaPlugin) {
        super(javaPlugin, "MBedwars");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBedBreak(ArenaBedBreakEvent arenaBedBreakEvent) {
        if (arenaBedBreakEvent.getResult() == ArenaBedBreakEvent.Result.CANCEL || !arenaBedBreakEvent.isPlayerCaused()) {
            return;
        }
        this.executionBuilder("break_bed").player(arenaBedBreakEvent.getPlayer()).root(arenaBedBreakEvent.getTeam().name()).subRoot("arena", arenaBedBreakEvent.getArena().getName()).progressSingle().buildAndExecute();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onTeamEliminate(TeamEliminateEvent teamEliminateEvent) {
        if (teamEliminateEvent.getCausingPlayer() == null) {
            return;
        }
        this.executionBuilder("team_eliminate").player(teamEliminateEvent.getCausingPlayer()).root(teamEliminateEvent.getTeam().name()).progressSingle().buildAndExecute();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onJoinArena(PlayerJoinArenaEvent playerJoinArenaEvent) {
        if (playerJoinArenaEvent.hasIssues()) {
            return;
        }
        this.executionBuilder("join_arena").player(playerJoinArenaEvent.getPlayer()).root(playerJoinArenaEvent.getTeam() == null ? "" : playerJoinArenaEvent.getTeam().name()).subRoot("cause", playerJoinArenaEvent.getCause().name()).progressSingle().buildAndExecute();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerKill(PlayerKillPlayerEvent playerKillPlayerEvent) {
        this.executionBuilder("kill").player(playerKillPlayerEvent.getKiller()).root(playerKillPlayerEvent.getCause().name()).subRoot("killed", playerKillPlayerEvent.getDamaged().getName()).subRoot("projectile", playerKillPlayerEvent.getProjectile() == null ? "" : playerKillPlayerEvent.getProjectile().getType().name()).progressSingle().buildAndExecute();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onStatChange(PlayerStatChangeEvent playerStatChangeEvent) {
        int n = (Integer)playerStatChangeEvent.getNewValue();
        if (playerStatChangeEvent.getOldValue() != null) {
            n -= ((Integer)playerStatChangeEvent.getOldValue()).intValue();
        }
        if (n < 1) {
            return;
        }
        this.executionBuilder("stat_change").player(Bukkit.getPlayer((UUID)playerStatChangeEvent.getStats().getPlayerUUID())).root(playerStatChangeEvent.getKey()).progress(n).buildAndExecute();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBuyInShop(PlayerBuyInShopEvent playerBuyInShopEvent) {
        if (!playerBuyInShopEvent.isGivingProducts()) {
            return;
        }
        this.executionBuilder("buy_item").player(playerBuyInShopEvent.getPlayer()).root(playerBuyInShopEvent.getItem().getName()).progress(playerBuyInShopEvent.getMultiplier()).subRoot("arena", playerBuyInShopEvent.getArena() == null ? "" : playerBuyInShopEvent.getArena().getName()).buildAndExecute();
    }
}

