/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.actions.external;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Set;
import me.clip.placeholderapi.PlaceholderAPI;
import net.advancedplugins.bp.impl.actions.external.executor.ActionQuestExecutor;
import net.advancedplugins.bp.impl.actions.objects.variable.ActionResult;
import net.advancedplugins.bp.impl.utils.ASManager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PlaceholderApiQuests
extends ActionQuestExecutor {
    private JavaPlugin plugin;
    private final Set<String> integerPlaceholders = Sets.newHashSet();
    private final Set<String> matchPlaceholders = Sets.newHashSet();

    public PlaceholderApiQuests(JavaPlugin javaPlugin, Set<String> set) {
        super(javaPlugin, "placeholderapi");
        this.plugin = javaPlugin;
        for (String string : set) {
            String string2;
            String string3 = string.substring(15);
            if (string3.startsWith("integer_")) {
                string2 = string3.substring(8);
                ASManager.debug("(PlaceholderAPI Quests) Adding placeholderapi integer quest with placeholder ".concat(string2));
                this.integerPlaceholders.add(string2);
                continue;
            }
            if (string3.startsWith("match_")) {
                string2 = string3.substring(6);
                ASManager.debug("(PlaceholderAPI Quests) Adding placeholderapi match quest with placeholder ".concat(string2));
                this.matchPlaceholders.add(string2);
                continue;
            }
            javaPlugin.getLogger().warning("Failed to parse PlaceholderAPI quest variable: ".concat(string));
        }
        this.placeholderRun();
    }

    private void placeholderRun() {
        if (this.matchPlaceholders.isEmpty() && this.integerPlaceholders.isEmpty()) {
            return;
        }
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                String string;
                for (String string2 : this.matchPlaceholders) {
                    string = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)("%" + string2 + "%"));
                    this.execute("match_".concat(string2), player, actionResult -> actionResult.root(string));
                }
                for (String string2 : this.integerPlaceholders) {
                    string = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)("%" + string2 + "%"));
                    String string3 = string.replaceAll("[^\\d.]", "");
                    if (string3.isEmpty()) continue;
                    this.execute("integer_".concat(string2), player, new BigDecimal(string).toBigInteger(), ActionResult::none, replacer -> replacer.set("placeholder_value", string), true);
                }
            }
        }, 40L, 40L);
    }
}

