/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.actions.external;

import java.util.function.UnaryOperator;
import net.advancedplugins.bp.impl.actions.external.executor.ActionQuestExecutor;
import net.advancedplugins.bp.impl.actions.objects.variable.ActionResult;
import net.brcdev.shopgui.event.ShopPostTransactionEvent;
import net.brcdev.shopgui.shop.ShopManager;
import net.brcdev.shopgui.shop.ShopTransactionResult;
import net.brcdev.shopgui.shop.item.ShopItem;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.plugin.java.JavaPlugin;

public class ShopGuiPlusQuests
extends ActionQuestExecutor {
    public ShopGuiPlusQuests(JavaPlugin javaPlugin) {
        super(javaPlugin, "shopguiplus");
    }

    @EventHandler(ignoreCancelled=true)
    public void afterShopTransaction(ShopPostTransactionEvent shopPostTransactionEvent) {
        ShopTransactionResult shopTransactionResult = shopPostTransactionEvent.getResult();
        if (shopTransactionResult.getResult() != ShopTransactionResult.ShopTransactionResultType.SUCCESS) {
            return;
        }
        Player player = shopTransactionResult.getPlayer();
        ShopManager.ShopAction shopAction = shopTransactionResult.getShopAction();
        ShopItem shopItem = shopTransactionResult.getShopItem();
        String string = shopItem.getShop().getId();
        int n = shopTransactionResult.getAmount();
        int n2 = (int)Math.ceil(shopTransactionResult.getPrice());
        UnaryOperator unaryOperator = actionResult -> actionResult.root(shopItem.getItem()).subRoot("shop", string).subRoot("item-id", shopItem.getId());
        if (shopAction == ShopManager.ShopAction.BUY) {
            super.execute("buy", player, n, (UnaryOperator<ActionResult>)unaryOperator);
            super.execute("buy_singular", player, unaryOperator);
            super.execute("spend", player, n2, (UnaryOperator<ActionResult>)unaryOperator);
        } else {
            super.execute("sell", player, n, (UnaryOperator<ActionResult>)unaryOperator);
            super.execute("sell_singular", player, unaryOperator);
            super.execute("profit", player, n2, (UnaryOperator<ActionResult>)unaryOperator);
        }
    }
}

