/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.actions.external.chestshop;

import com.Acrobot.ChestShop.Events.ShopCreatedEvent;
import com.Acrobot.ChestShop.Events.ShopDestroyedEvent;
import com.Acrobot.ChestShop.Events.TransactionEvent;
import java.util.UUID;
import net.advancedplugins.bp.impl.actions.external.executor.ActionQuestExecutor;
import net.advancedplugins.bp.impl.actions.objects.variable.ActionResult;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.plugin.java.JavaPlugin;

public class ChestShopQuests
extends ActionQuestExecutor {
    public ChestShopQuests(JavaPlugin javaPlugin) {
        super(javaPlugin, "chestshop");
    }

    @EventHandler(ignoreCancelled=true)
    public void afterShopCreate(ShopCreatedEvent shopCreatedEvent) {
        Player player = shopCreatedEvent.getPlayer();
        this.execute("create", player, ActionResult::none);
    }

    @EventHandler(ignoreCancelled=true)
    public void onTransaction(TransactionEvent transactionEvent) {
        Player player = transactionEvent.getClient();
        Player player2 = Bukkit.getPlayer((UUID)transactionEvent.getOwnerAccount().getUuid());
        int n = transactionEvent.getExactPrice().intValue();
        if (player == null || player2 == null) {
            return;
        }
        if (transactionEvent.getTransactionType() == TransactionEvent.TransactionType.BUY) {
            this.execute("buy", player, actionResult -> actionResult.root(player2.getName()));
            this.execute("sell", player2, actionResult -> actionResult.root(player.getName()));
            this.execute("spend", player, n, actionResult -> actionResult.root(player2.getName()));
            this.execute("profit", player2, n, actionResult -> actionResult.root(player.getName()));
        } else {
            this.execute("buy", player2, actionResult -> actionResult.root(player.getName()));
            this.execute("sell", player, actionResult -> actionResult.root(player2.getName()));
            this.execute("spend", player2, n, actionResult -> actionResult.root(player.getName()));
            this.execute("profit", player, n, actionResult -> actionResult.root(player2.getName()));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void afterShopCreate(ShopDestroyedEvent shopDestroyedEvent) {
        Player player = shopDestroyedEvent.getDestroyer();
        this.execute("destroy", player, ActionResult::none);
    }
}

