/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.actions.internal;

import net.advancedplugins.bp.impl.actions.ActionRegistry;
import net.advancedplugins.bp.impl.actions.containers.ActionContainer;
import net.advancedplugins.bp.impl.utils.nbt.utils.MinecraftVersion;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class BlockPlaceQuest
extends ActionContainer {
    private final JavaPlugin plugin;

    public BlockPlaceQuest(JavaPlugin javaPlugin) {
        super(javaPlugin);
        this.plugin = javaPlugin;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockPlaceEvent blockPlaceEvent) {
        Player player = blockPlaceEvent.getPlayer();
        Block block = blockPlaceEvent.getBlock();
        if (block.getType() == Material.FIRE || MinecraftVersion.getVersion().getVersionId() >= MinecraftVersion.MC1_16_R1.getVersionId() && block.getType() == Material.SOUL_FIRE) {
            return;
        }
        boolean bl = false;
        if (MinecraftVersion.isNew() && block.getBlockData() instanceof Ageable) {
            bl = true;
        }
        if (!bl && !ActionRegistry.isIgnoreBlockCache()) {
            ActionRegistry.getBlockCache().insertLocation(blockPlaceEvent.getBlock().getLocation());
        }
        this.executionBuilder("block-place").player(player).root(block).progressSingle().buildAndExecute();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPiston(BlockPistonExtendEvent blockPistonExtendEvent) {
        if (!ActionRegistry.getBlockCache().removeIfExists(blockPistonExtendEvent.getBlock().getLocation())) {
            return;
        }
        Location location = blockPistonExtendEvent.getBlock().getLocation().add(blockPistonExtendEvent.getDirection().getDirection());
        ActionRegistry.getBlockCache().insertLocation(location);
    }
}

