/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.actions.internal;

import java.util.concurrent.CompletableFuture;
import net.advancedplugins.bp.impl.actions.containers.ActionContainer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CraftQuest
extends ActionContainer {
    private final JavaPlugin plugin;

    public CraftQuest(JavaPlugin javaPlugin) {
        super(javaPlugin);
        this.plugin = javaPlugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onCraftItem(CraftItemEvent craftItemEvent) {
        Player player = (Player)craftItemEvent.getWhoClicked();
        ItemStack itemStack = craftItemEvent.getCurrentItem();
        if (itemStack == null) {
            return;
        }
        this.getCraftedAmount(craftItemEvent).thenAccept(n -> this.executionBuilder("craft").player(player).progress((int)n).root(craftItemEvent.getRecipe().getResult()).buildAndExecute());
    }

    private CompletableFuture<Integer> getCraftedAmount(CraftItemEvent craftItemEvent) {
        ClickType clickType = craftItemEvent.getClick();
        if (clickType != ClickType.SHIFT_LEFT && clickType != ClickType.SHIFT_RIGHT) {
            ItemStack itemStack = craftItemEvent.getCursor();
            ItemStack itemStack2 = craftItemEvent.getRecipe().getResult();
            if (itemStack != null && itemStack.getAmount() > 0 && (itemStack.getType() != itemStack2.getType() || itemStack.getAmount() + itemStack2.getAmount() > itemStack.getMaxStackSize())) {
                CompletableFuture<Integer> completableFuture = new CompletableFuture<Integer>();
                completableFuture.cancel(false);
                return completableFuture;
            }
            return CompletableFuture.completedFuture(craftItemEvent.getCurrentItem().getAmount());
        }
        CompletableFuture<Integer> completableFuture = new CompletableFuture<Integer>();
        Player player = (Player)craftItemEvent.getWhoClicked();
        ItemStack itemStack = craftItemEvent.getRecipe().getResult();
        int n = this.calculateAmount(itemStack, player.getInventory().getStorageContents());
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            int n2 = this.calculateAmount(itemStack, player.getInventory().getStorageContents());
            int n3 = n2 - n;
            if (n3 < 1) {
                completableFuture.cancel(false);
                return;
            }
            completableFuture.complete(n3);
        }, 1L);
        return completableFuture;
    }

    private int calculateAmount(ItemStack itemStack, ItemStack[] itemStackArray) {
        int n = 0;
        for (ItemStack itemStack2 : itemStackArray) {
            if (itemStack2 == null || !itemStack2.isSimilar(itemStack)) continue;
            n += itemStack2.getAmount();
        }
        return n;
    }
}

