/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.actions.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.advancedplugins.bp.impl.actions.containers.ActionContainer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class EntityBreedQuest
extends ActionContainer {
    private static boolean hasSniffers;
    private Map<Integer, Player> snifferBreeders = new HashMap<Integer, Player>();

    public EntityBreedQuest(JavaPlugin javaPlugin) {
        super(javaPlugin);
    }

    @EventHandler
    public void onBreed(EntityBreedEvent entityBreedEvent) {
        LivingEntity livingEntity = entityBreedEvent.getBreeder();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        LivingEntity livingEntity2 = entityBreedEvent.getEntity();
        String string = entityBreedEvent.getEntity().getCustomName();
        this.executionBuilder("breed").player(player).root(livingEntity2.getType().toString()).subRoot("name", string).progressSingle().buildAndExecute();
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemSpawn(ItemSpawnEvent itemSpawnEvent) {
        if (!hasSniffers) {
            return;
        }
        Item item = itemSpawnEvent.getEntity();
        if (!item.getItemStack().getType().name().equals("SNIFFER_EGG")) {
            return;
        }
        Location location = item.getLocation();
        Collection collection = location.getWorld().getNearbyEntities(item.getBoundingBox().expand(0.5, 0.5, 0.5));
        for (Entity entity : collection) {
            Player player;
            if (!entity.getType().toString().equals("SNIFFER") || (player = this.snifferBreeders.get(entity.getEntityId())) == null) continue;
            this.snifferBreeders.remove(entity.getEntityId());
            Collection collection2 = entity.getLocation().getWorld().getNearbyEntities(entity.getBoundingBox().expand(1.0, 1.0, 1.0));
            for (Entity entity2 : collection2) {
                if (entity2 == entity || !entity2.getType().toString().equals("SNIFFER")) continue;
                this.snifferBreeders.remove(entity2.getEntityId());
            }
            String string = entity.getCustomName();
            this.executionBuilder("breed").player(player).root("SNIFFER").subRoot("name", string).progressSingle().buildAndExecute();
            break;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEnterLoveMode(EntityEnterLoveModeEvent entityEnterLoveModeEvent) {
        if (!hasSniffers) {
            return;
        }
        if (!entityEnterLoveModeEvent.getEntity().getType().toString().equals("SNIFFER")) {
            return;
        }
        this.snifferBreeders.put(entityEnterLoveModeEvent.getEntity().getEntityId(), (Player)entityEnterLoveModeEvent.getHumanEntity());
    }

    static {
        try {
            hasSniffers = EntityType.valueOf((String)"SNIFFER") != null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            hasSniffers = false;
        }
    }
}

