/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.actions.internal;

import com.google.common.collect.HashMultiset;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import net.advancedplugins.bp.impl.actions.containers.ActionContainer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class SmeltQuest
extends ActionContainer {
    public SmeltQuest(JavaPlugin javaPlugin) {
        super(javaPlugin);
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        ItemStack itemStack2 = inventoryClickEvent.getCursor();
        if (!inventoryClickEvent.getInventory().getType().toString().contains("FURNACE") && !inventoryClickEvent.getInventory().getType().toString().contains("SMOKER") || inventoryClickEvent.getSlotType() != InventoryType.SlotType.RESULT || itemStack == null) {
            return;
        }
        if (itemStack2 != null && itemStack2.getType() != Material.AIR && itemStack.getType() != itemStack2.getType() && !inventoryClickEvent.isShiftClick()) {
            return;
        }
        int n = itemStack.getAmount();
        if (inventoryClickEvent.isShiftClick()) {
            int n2 = this.hasRoomForItem(player, itemStack);
            if (n2 == -420 || n2 == 0) {
                return;
            }
            n = n2;
        } else if (itemStack2 != null && itemStack2.getType() == itemStack.getType() && itemStack2.getAmount() + itemStack.getAmount() > itemStack.getMaxStackSize()) {
            return;
        }
        if (inventoryClickEvent.getClick().equals((Object)ClickType.DROP)) {
            n = 1;
        }
        this.executionBuilder("smelt").player(player).progress(n).root(itemStack).buildAndExecute();
    }

    private int hasRoomForItem(Player player, ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        int n = Math.min(this.getMaterialSpace(player, itemStack.getType()), itemStack.getAmount());
        if (player.getInventory().firstEmpty() != -1) {
            if (itemStack.getMaxStackSize() != 1) {
                return n;
            }
            int n2 = 0;
            for (ItemStack itemStack2 : player.getInventory().getContents()) {
                if (itemStack2 != null) continue;
                ++n2;
            }
            return n2;
        }
        HashMultiset hashMultiset = HashMultiset.create();
        for (ItemStack itemStack3 : player.getInventory().getContents()) {
            if (itemStack3 == null || itemStack3.getType() != itemStack.getType() || itemStack3.getAmount() >= itemStack3.getMaxStackSize()) continue;
            hashMultiset.add((Object)itemStack3.getAmount());
        }
        if (hashMultiset.size() <= 0) {
            return -420;
        }
        int n3 = 0;
        Iterator iterator = hashMultiset.iterator();
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            n3 += n4;
        }
        return Math.min(hashMultiset.size() * 64 - n3, n);
    }

    private int getMaterialSpace(Player player, Material material) {
        AtomicInteger atomicInteger = new AtomicInteger();
        for (ItemStack itemStack : player.getInventory()) {
            atomicInteger.addAndGet(itemStack == null ? material.getMaxStackSize() : (itemStack.getType() == material ? material.getMaxStackSize() - itemStack.getAmount() : 0));
        }
        return atomicInteger.get();
    }
}

