/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.actions.objects.variable;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.advancedplugins.bp.impl.actions.utils.MultiMaterial;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class Variable {
    private final String[] roots;
    private final Set<ImmutablePair<String, Byte>> materialRoots = Sets.newHashSet();
    private Map<String, List<String>> subRoots = Maps.newHashMap();

    public Variable(String string) {
        this.roots = string.split(" OR ");
        this.parseRoots();
    }

    public Variable(String string, Map<String, List<String>> map) {
        this.roots = string.split(" OR ");
        this.subRoots = map;
        this.parseRoots();
    }

    public String[] getRoots() {
        return this.roots;
    }

    public Map<String, List<String>> getSubRoots() {
        return this.subRoots;
    }

    public Set<ImmutablePair<String, Byte>> getMaterialRoots() {
        return this.materialRoots;
    }

    private void parseRoots() {
        for (int i = 0; i < this.roots.length; ++i) {
            String[] stringArray = this.roots[i].split(":");
            ItemStack itemStack = MultiMaterial.parseItem(this.roots[i].toUpperCase().replace(":ALL", ":0"));
            byte by = stringArray.length > 1 ? (stringArray[1].equalsIgnoreCase("all") ? (byte)-1 : Byte.parseByte(stringArray[1])) : (byte)0;
            this.materialRoots.add((ImmutablePair<String, Byte>)ImmutablePair.of((Object)itemStack.getType().toString(), (Object)by));
            this.roots[i] = stringArray[0];
        }
    }

    public static Variable of(YamlConfiguration yamlConfiguration, String string2) {
        HashMap hashMap = Maps.newHashMap();
        BiConsumer<String, Supplier<String>> biConsumer = (string, supplier) -> hashMap.put(string, Arrays.asList(((String)supplier.get()).split(" OR ")));
        if (yamlConfiguration.get(string2.concat("variable")) instanceof MemorySection) {
            String string3 = yamlConfiguration.getString(string2.concat("variable.root"), "none");
            String string4 = string2.concat("variable.");
            if (yamlConfiguration.contains(string4.concat("holding"))) {
                Variable.apply(biConsumer, yamlConfiguration, string4, "holding.item");
                Variable.apply(biConsumer, yamlConfiguration, string4, "holding.name");
                Variable.apply(biConsumer, yamlConfiguration, string4, "holding.amount");
            }
            for (String string5 : yamlConfiguration.getConfigurationSection(string2.concat("variable")).getKeys(false)) {
                if (string5.equalsIgnoreCase("root") || string5.equalsIgnoreCase("holding")) continue;
                biConsumer.accept(string5, () -> yamlConfiguration.getString(string2 + "variable." + string5));
            }
            return new Variable(string3, hashMap);
        }
        if (yamlConfiguration.contains(string2.concat("variable"))) {
            return new Variable(yamlConfiguration.getString(string2.concat("variable")));
        }
        return new Variable("none");
    }

    private static void apply(BiConsumer<String, Supplier<String>> biConsumer, YamlConfiguration yamlConfiguration, String string, String string2) {
        if (yamlConfiguration.contains(string.concat(string2))) {
            biConsumer.accept(string2, () -> yamlConfiguration.getString(string.concat(string2)));
        }
    }
}

