/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.utils.commands;

import java.util.Arrays;
import java.util.LinkedList;
import net.advancedplugins.bp.impl.utils.commands.Command;
import net.advancedplugins.bp.impl.utils.commands.SubCommand;
import net.advancedplugins.bp.impl.utils.text.Text;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class SimpleCommand<T extends CommandSender>
extends Command<T> {
    private final String command;
    private Integer pageCount;
    private final int COMMANDS_PER_PAGE = 9;
    private LinkedList<SubCommand<? extends CommandSender>> subCommands = new LinkedList();

    public SimpleCommand(JavaPlugin javaPlugin, String string, String string2, boolean bl) {
        super(javaPlugin, string2, bl);
        this.command = string;
    }

    public SimpleCommand(JavaPlugin javaPlugin, String string, boolean bl) {
        this(javaPlugin, string, "", bl);
    }

    public SimpleCommand(JavaPlugin javaPlugin, String string, String string2) {
        this(javaPlugin, string, string2, true);
    }

    public SimpleCommand(JavaPlugin javaPlugin, String string) {
        this(javaPlugin, string, true);
    }

    public String getCommand() {
        return this.command;
    }

    public LinkedList<SubCommand<? extends CommandSender>> getSubCommands() {
        return this.subCommands;
    }

    public void setSubCommands(LinkedList<SubCommand<? extends CommandSender>> linkedList) {
        this.subCommands = linkedList;
    }

    protected void setSubCommands(SubCommand<? extends CommandSender> ... subCommandArray) {
        this.subCommands.addAll(Arrays.asList(subCommandArray));
    }

    public void sendHelpMessage(Plugin plugin, CommandSender commandSender) {
        PluginDescriptionFile pluginDescriptionFile = plugin.getDescription();
        Text.sendMessage(commandSender, "&f".concat(pluginDescriptionFile.getName()).concat(" &7v").concat(pluginDescriptionFile.getVersion()));
        Text.sendMessage(commandSender, "&7Use &f&n".concat(this.command).concat(" to view usage information."));
    }

    public void sendHelpPage(CommandSender commandSender, String string, String[] stringArray) {
        if (this.pageCount == null) {
            this.pageCount = (int)Math.ceil((float)this.subCommands.size() / 9.0f);
        }
        int n = (stringArray.length == 0 ? 0 : (StringUtils.isNumeric((String)stringArray[0]) ? Math.max(0, Integer.parseInt(stringArray[0])) : 1)) - 1;
        n = Math.min(Math.max(0, n), this.pageCount);
        PluginDescriptionFile pluginDescriptionFile = this.plugin.getDescription();
        Text.sendMessage(commandSender, string + "[<] &8+-------< " + string + "&l" + pluginDescriptionFile.getName().concat(" &7Page " + (n + 1) + "/" + this.pageCount) + " &8>-------+ " + string + "[>]");
        Text.sendMessage(commandSender, " ");
        for (SubCommand subCommand : this.subCommands.subList(n * 9, Math.min(this.subCommands.size(), (n + 1) * 9))) {
            Text.sendMessage(commandSender, "  " + subCommand.getFormatted(this.command));
        }
        Text.sendMessage(commandSender, " ");
        Text.sendMessage(commandSender, "  &2<> &f- Required Arguments&7; &9[] &f- Optional Arguments");
        Text.sendMessage(commandSender, string + "[<] &8+-------< " + string + "&l" + pluginDescriptionFile.getName().concat(" &7v" + pluginDescriptionFile.getVersion() + " &8>-------+ " + string + "[>]"));
    }
}

