/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.utils.configs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import net.advancedplugins.bp.impl.utils.ASManager;
import net.advancedplugins.bp.impl.utils.nbt.utils.MinecraftVersion;
import net.advancedplugins.bp.impl.utils.text.Text;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlFile {
    public static final YamlFile ANVIL = new YamlFile("anvil.yml");
    public static final YamlFile CONFIG = new YamlFile("config.yml");
    public static final YamlFile ENCHANTMENTS = new YamlFile("enchantments.yml", false);
    public static final YamlFile MOB_HEADS = new YamlFile("mobHeads.yml");
    public static final YamlFile MOBS = new YamlFile("mobs.yml");
    public static final YamlFile PDATA = new YamlFile("pdata.yml");
    public static final YamlFile TINKERER = new YamlFile("menus/tinkerer.yml");
    public static final YamlFile ALCHEMIST = new YamlFile("menus/alchemist.yml");
    public static final YamlFile ENCHANTER = new YamlFile("menus/enchanter.yml");
    public static final YamlFile GKITS = new YamlFile("menus/gkits.yml");
    public static final YamlFile ASETS_PREVIEW = new YamlFile("menus/armorSetsPreview.yml");
    public static final YamlFile COMMANDS = new YamlFile("menus/customcommands.yml");
    private final File file;
    private YamlConfiguration cfg;
    private boolean autoUpdate = true;

    public YamlFile(String string) {
        assert (string != null) : "File name cannot be null!";
        string = string.endsWith(".yml") ? string : string + ".yml";
        string = string.replace("/", File.separator);
        this.file = new File(ASManager.getInstance().getDataFolder() + File.separator + string);
        this.writeFileIfNotExists();
        this.reload();
    }

    public YamlFile(String string, boolean bl) {
        this(string);
        this.autoUpdate = bl;
    }

    public YamlFile(File file) {
        this.file = file;
        file.getParentFile().mkdirs();
        this.writeFileIfNotExists();
        this.reload();
    }

    private void writeFileIfNotExists() {
        if (this.file.exists()) {
            return;
        }
        String string = this.getInternalName(this.file);
        try (InputStream inputStream = ASManager.getInstance().getResource(string);){
            if (inputStream != null) {
                ASManager.getInstance().saveResource(string, true);
            } else {
                this.file.createNewFile();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private synchronized void writeToFile(InputStream inputStream) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.file);){
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            if (inputStream == null) {
                return;
            }
            while ((n = inputStream.read()) != -1) {
                stringBuilder.append((char)n);
            }
            byte[] byArray = stringBuilder.toString().getBytes();
            fileOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public File getFile() {
        return this.file;
    }

    public synchronized void save() {
        try {
            this.cfg.save(this.file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public synchronized void reload() {
        if (!this.file.exists()) {
            this.writeFileIfNotExists();
        }
        try {
            this.cfg = new YamlConfiguration();
            this.cfg.load((Reader)new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8));
        }
        catch (IOException | InvalidConfigurationException throwable) {
            this.autoUpdate = false;
            String string = this.getInternalName(this.file);
            ASManager.getInstance().getLogger().severe("Failed to load config file \"" + string + "\"! Please ensure that it doesn't have any syntax errors. You can check for syntax errors with this website: \"https://www.yamlchecker.com/\". If you see any errors this, this is most likely the cause of them.");
            throwable.printStackTrace();
            try (InputStream inputStream = ASManager.getInstance().getResource(string);){
                if (inputStream != null) {
                    this.cfg.load((Reader)new InputStreamReader(inputStream));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private String getInternalName(File file) {
        return file.getAbsolutePath().replace(ASManager.getInstance().getDataFolder().getAbsolutePath() + File.separator, "").replace(File.separatorChar, '/');
    }

    public boolean contains(String string) {
        return this.cfg.contains(string);
    }

    public boolean isConfigSection(String string) {
        return this.cfg.isConfigurationSection(string);
    }

    public Set<String> getKeys(String string) {
        return this.getConfigSection(string).getKeys(false);
    }

    public Object get(String string) {
        return this.cfg.get(string);
    }

    public Object get(String string, Object object) {
        this.update(string, object);
        return this.cfg.get(string, object);
    }

    public Location getLocation(String string) {
        if (MinecraftVersion.getVersionNumber() >= 1140) {
            return this.cfg.getLocation(string);
        }
        String[] stringArray = this.getString(string).split(";");
        World world = Bukkit.getWorld((String)stringArray[0]);
        double d = Double.parseDouble(stringArray[1]);
        double d2 = Double.parseDouble(stringArray[2]);
        double d3 = Double.parseDouble(stringArray[3]);
        return new Location(world, d, d2, d3);
    }

    public int getInt(String string) {
        return this.cfg.getInt(string);
    }

    public int getInt(String string, int n) {
        this.update(string, n);
        return this.cfg.getInt(string, n);
    }

    public long getLong(String string) {
        return this.cfg.getLong(string);
    }

    public long getLong(String string, long l) {
        this.update(string, l);
        return this.cfg.getLong(string, l);
    }

    public double getDouble(String string) {
        return this.cfg.getDouble(string);
    }

    public double getDouble(String string, double d) {
        this.update(string, d);
        return this.cfg.getDouble(string, d);
    }

    public boolean getBoolean(String string) {
        return this.cfg.getBoolean(string);
    }

    public boolean getBoolean(String string, boolean bl) {
        this.update(string, bl);
        return this.cfg.getBoolean(string, bl);
    }

    public String getString(String string) {
        return Text.modify(this.cfg.getString(string));
    }

    public String getString(String string, String string2) {
        this.update(string, string2);
        return Text.modify(this.cfg.getString(string, string2));
    }

    public List<String> getStringList(String string) {
        return Text.modify(this.cfg.getStringList(string));
    }

    public List<String> getStringList(String string, List<String> list) {
        this.update(string, list);
        return Text.modify(this.cfg.getStringList(string));
    }

    public ConfigurationSection getConfigSection(String string) {
        return this.cfg.getConfigurationSection(string);
    }

    private void update(String string, Object object) {
        if (!this.contains(string)) {
            this.set(string, object);
            if (this.autoUpdate) {
                this.save();
            }
        }
    }

    public void set(String string, Object object) {
        this.cfg.set(string, object);
    }

    public YamlConfiguration getConfig() {
        return this.cfg;
    }
}

