/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.utils.configs;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.advancedplugins.bp.impl.utils.ASManager;
import net.advancedplugins.bp.impl.utils.configs.YamlFile;

public class YamlFolder {
    public static final YamlFolder ARMOR_SETS = new YamlFolder("armorSets");
    public static final YamlFolder CUSTOM_WEAPONS = new YamlFolder("customWeapons");
    private final Map<String, YamlFile> dataFiles = new HashMap<String, YamlFile>();
    private final String folder;

    public YamlFolder(String string) {
        this.folder = string;
        File file = ASManager.getInstance().getDataFolder();
        File file2 = new File(file.getAbsolutePath() + File.separator + string);
        boolean bl = true;
        if (!file2.exists() || !file2.isDirectory()) {
            file2.mkdirs();
            bl = false;
        }
        this.initExisting();
        if (!bl) {
            this.writeToDisk();
        }
    }

    private void writeToDisk() {
        block9: {
            try {
                CodeSource codeSource = ASManager.class.getProtectionDomain().getCodeSource();
                if (codeSource == null) break block9;
                URL uRL = codeSource.getLocation();
                try (ZipInputStream zipInputStream = new ZipInputStream(uRL.openStream());){
                    ZipEntry zipEntry;
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        File file;
                        String string = zipEntry.getName();
                        if (!this.isYamlFile(string) || !string.startsWith(this.folder) || !string.contains("/") || (file = new File(ASManager.getInstance().getDataFolder(), string)).isDirectory()) continue;
                        string = string.replace("/", File.separator);
                        this.dataFiles.put(string, new YamlFile(file));
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void initExisting() {
        for (File file : YamlFolder.getNestedFiles(new File(ASManager.getInstance().getDataFolder(), this.folder))) {
            if (!this.isYamlFile(file.getName())) continue;
            String string = file.getPath().replace(ASManager.getInstance().getDataFolder().getPath() + File.separator, "");
            this.dataFiles.put(string, new YamlFile(file));
        }
    }

    private boolean isYamlFile(String string) {
        if (!string.contains(".")) {
            return false;
        }
        return string.substring(string.lastIndexOf(46)).toLowerCase(Locale.ROOT).equals(".yml");
    }

    public YamlFile getDataFile(String string) {
        string = (string = string.replace("/", File.separator)).startsWith(this.folder) ? string : this.folder + File.separator + string;
        string = string.endsWith(".yml") ? string : string + ".yml";
        return this.dataFiles.get(string);
    }

    public YamlFile getDataFile(File file) {
        String string = file.getPath().replace(ASManager.getInstance().getDataFolder().getPath() + File.separator, "");
        return this.getDataFile(string);
    }

    public Collection<YamlFile> getDataFiles() {
        return this.dataFiles.values();
    }

    private static List<File> getNestedFiles(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                arrayList.addAll(YamlFolder.getNestedFiles(file2));
                continue;
            }
            arrayList.add(file2);
        }
        return arrayList;
    }
}

