/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.utils.editor;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.advancedplugins.bp.impl.utils.ASManager;
import net.advancedplugins.bp.impl.utils.SkullCreator;
import net.advancedplugins.bp.impl.utils.editor.ConfigEditorGui;
import net.advancedplugins.bp.impl.utils.editor.ConfigEditorHandler;
import net.advancedplugins.bp.impl.utils.editor.KeyInfo;
import net.advancedplugins.bp.impl.utils.items.ItemBuilder;
import net.advancedplugins.bp.impl.utils.nbt.NBTapi;
import net.advancedplugins.bp.impl.utils.text.Text;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigEditorMenu
implements Listener {
    private static ConfigEditorHandler handler;
    private Inventory inv;
    private int page = 0;
    private final int totalPages;
    private final int entriesPerPage = 45;
    private final Player editor;
    private final LinkedList<KeyInfo> keyInfos;
    private final String inventoryName;
    private boolean creatingNew = false;

    public ConfigEditorMenu(Player player, String string, LinkedList<KeyInfo> linkedList, JavaPlugin javaPlugin) {
        this.editor = player;
        this.keyInfos = linkedList;
        this.inventoryName = string;
        this.totalPages = ASManager.getPages(linkedList.size(), 45);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)javaPlugin);
    }

    public void open() {
        this.inv = Bukkit.createInventory(null, (int)54, (String)Text.modify(this.inventoryName));
        this.inv.setMaxStackSize(ThreadLocalRandom.current().nextInt(64, 256));
        List list = this.keyInfos.subList(this.page * 45, Math.min((this.page + 1) * 45, this.keyInfos.size()));
        int n = 1;
        for (KeyInfo keyInfo : list) {
            ItemBuilder itemBuilder = new ItemBuilder(keyInfo.displayMaterial);
            itemBuilder.setName(keyInfo.name);
            itemBuilder.addLoreLine(Text.modify(" &7&l(!) &7" + keyInfo.description));
            itemBuilder.addLoreLine(" ");
            itemBuilder.addLoreLine(Text.modify(" &7\u27a4 &nLeft Click&7 here to start editing."));
            if (keyInfo.wikiLink != null) {
                itemBuilder.addLoreLine(Text.modify(" &7\u24d8 &nRight Click&7 here to read more."));
            }
            itemBuilder.addItemFlag(ItemFlag.values());
            ItemStack itemStack = itemBuilder.toItemStack();
            itemStack = NBTapi.addNBTTag("editKey", keyInfo.name, itemStack);
            itemStack.setAmount(n);
            this.inv.addItem(new ItemStack[]{itemStack});
            ++n;
        }
        for (int i = this.inv.getSize() - 9; i < this.inv.getSize(); ++i) {
            this.inv.setItem(i, new ItemBuilder(Material.matchMaterial((String)(handler.getGlassColor() + "_STAINED_GLASS_PANE"))).setGlowing(true).setName(" ").toItemStack());
        }
        if (ConfigEditorMenu.getHandler().canCreateNewEntries()) {
            this.inv.setItem(this.inv.getSize() - 1, NBTapi.addNBTTag("action", "create", new ItemBuilder(Material.LIME_WOOL).setName(Text.modify("&a&lCreate a new one!")).addLoreLine(Text.modify("&e&lClick here to start the creation process.")).toItemStack()));
        }
        if (this.page + 1 < this.totalPages) {
            this.inv.setItem(this.inv.getSize() - 4, NBTapi.addNBTTag("action", "next", new ItemBuilder(SkullCreator.itemFromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTliZjMyOTJlMTI2YTEwNWI1NGViYTcxM2FhMWIxNTJkNTQxYTFkODkzODgyOWM1NjM2NGQxNzhlZDIyYmYifX19")).setName(Text.modify("&8>> &6Next Page")).setAmount(this.page + 1).toItemStack()));
        }
        if (this.page > 0) {
            this.inv.setItem(this.inv.getSize() - 6, NBTapi.addNBTTag("action", "back", new ItemBuilder(SkullCreator.itemFromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmQ2OWUwNmU1ZGFkZmQ4NGU1ZjNkMWMyMTA2M2YyNTUzYjJmYTk0NWVlMWQ0ZDcxNTJmZGM1NDI1YmMxMmE5In19fQ")).setName(Text.modify("&8<< &6Previous Page")).setAmount(Math.max(1, this.page)).toItemStack()));
        }
        ConfigEditorMenu.placeFiller(this.inv, this.editor);
        this.editor.openInventory(this.inv);
    }

    static void placeFiller(Inventory inventory, Player player) {
        ItemStack itemStack = new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).setName(" ").toItemStack();
        for (int i = 0; i < inventory.getSize() - 9; ++i) {
            if (inventory.getItem(i) != null) continue;
            inventory.setItem(i, itemStack);
        }
    }

    private KeyInfo matchKeyInfoWithName(String string) {
        return this.keyInfos.stream().filter(keyInfo -> string.equals(keyInfo.name)).findFirst().orElse(null);
    }

    @EventHandler
    public void onCreate(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (this.creatingNew && asyncPlayerChatEvent.getPlayer().equals(this.editor)) {
            handler.create(asyncPlayerChatEvent.getMessage(), this.editor);
            HandlerList.unregisterAll((Listener)this);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        if (inventoryClickEvent.getInventory().equals(this.inv)) {
            inventoryClickEvent.setCancelled(true);
            ItemStack itemStack = inventoryClickEvent.getCurrentItem();
            if (NBTapi.contains("action", itemStack)) {
                String string = NBTapi.get("action", itemStack);
                if (string.equalsIgnoreCase("back")) {
                    --this.page;
                    this.open();
                } else if (string.equalsIgnoreCase("next")) {
                    ++this.page;
                    this.open();
                } else if (string.equalsIgnoreCase("create")) {
                    inventoryClickEvent.getWhoClicked().closeInventory();
                    this.editor.sendMessage(Text.modify("name for new item"));
                    this.creatingNew = true;
                }
                return;
            }
            if (NBTapi.contains("editKey", itemStack)) {
                ConfigEditorGui configEditorGui = handler.openEditor(this.matchKeyInfoWithName(NBTapi.get("editKey", itemStack)), (Player)inventoryClickEvent.getWhoClicked());
                configEditorGui.open();
                HandlerList.unregisterAll((Listener)this);
            }
        }
    }

    public static ConfigEditorHandler getHandler() {
        return handler;
    }

    public static void setHandler(ConfigEditorHandler configEditorHandler) {
        handler = configEditorHandler;
    }
}

