/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.utils.text;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.advancedplugins.bp.impl.utils.nbt.utils.MinecraftVersion;
import net.advancedplugins.bp.impl.utils.text.Replace;
import net.advancedplugins.bp.impl.utils.text.Replacer;
import net.md_5.bungee.api.ChatColor;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Text {
    private static final char SECTION_CHAR = '\u00a7';
    private static final char AMPERSAND_CHAR = '&';
    private static final String COLOR_CODES = "0123456789AaBbCcDdEeFfKkLlMmNnOoRr";
    private static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    private static final Pattern HEX_PATTERN = Pattern.compile("\\{#[a-fA-F0-9]{6}}");

    public static void sendMessage(CommandSender commandSender, String string) {
        Supplier<String> supplier = () -> {
            if (!(commandSender instanceof OfflinePlayer) || Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                // empty if block
            }
            return string;
        };
        commandSender.sendMessage(Text.modify(supplier.get()));
    }

    public static void sendMessage(Collection<CommandSender> collection, String string) {
        for (CommandSender commandSender : collection) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\n")) {
                Text.sendMessage(commandSender, string2);
            }
        }
    }

    public static String modify(String string) {
        return Text.modify(string, null);
    }

    public static String modify(String string, Replace replace) {
        return string == null ? null : Text.renderColorCodes(replace == null ? string : ((Replacer)replace.apply(new Replacer())).applyTo(string));
    }

    public static List<String> modify(List<String> list) {
        return Text.modify(list, null);
    }

    public static List<String> modify(List<String> list, Replace replace) {
        if (list == null) {
            return null;
        }
        ArrayList arrayList = Lists.newArrayList();
        for (String string : list) {
            arrayList.add(Text.modify(string, replace));
        }
        return arrayList;
    }

    public static ItemStack modify(ItemStack itemStack, Replace replace) {
        ItemStack itemStack2 = itemStack.clone();
        ItemMeta itemMeta = itemStack2.getItemMeta();
        if (itemMeta == null) {
            return itemStack2;
        }
        itemMeta.setDisplayName(Text.modify(itemMeta.getDisplayName(), replace));
        itemMeta.setLore(Text.modify(itemMeta.getLore(), replace));
        itemStack2.setItemMeta(itemMeta);
        return itemStack2;
    }

    public static String decolorize(String string) {
        return string == null ? null : Text.unrenderColorCodes(string);
    }

    private static String unrenderColorCodes(String string) {
        return string == null ? null : STRIP_COLOR_PATTERN.matcher(string).replaceAll("");
    }

    private static String renderColorCodes(String string) {
        Object object;
        if (MinecraftVersion.getVersion().getVersionId() >= 1160) {
            object = HEX_PATTERN.matcher(string);
            while (((Matcher)object).find()) {
                String string2 = string.substring(((Matcher)object).start(), ((Matcher)object).end());
                string = StringUtils.replace((String)string, (String)string2, (String)("" + ChatColor.of((String)string2.replace("{", "").replace("}", ""))));
                object = HEX_PATTERN.matcher(string);
            }
        }
        object = string.toCharArray();
        for (int i = 0; i < ((Object)object).length - 1; ++i) {
            if (object[i] != 38 || COLOR_CODES.indexOf((int)object[i + 1]) <= -1) continue;
            object[i] = 167;
            object[i + 1] = Character.toLowerCase((char)object[i + 1]);
        }
        return new String((char[])object);
    }
}

