/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.differentiation;

import java.io.Serializable;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.analysis.differentiation.DSCompiler;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivativeStructure
implements RealFieldElement<DerivativeStructure>,
Serializable {
    private static final long serialVersionUID = 20120730L;
    private transient DSCompiler compiler;
    private final double[] data;

    private DerivativeStructure(DSCompiler dSCompiler) {
        this.compiler = dSCompiler;
        this.data = new double[dSCompiler.getSize()];
    }

    public DerivativeStructure(int n, int n2) {
        this(DSCompiler.getCompiler(n, n2));
    }

    public DerivativeStructure(int n, int n2, double d) {
        this(n, n2);
        this.data[0] = d;
    }

    public DerivativeStructure(int n, int n2, int n3, double d) {
        this(n, n2, d);
        if (n3 >= n) {
            throw new NumberIsTooLargeException(n3, (Number)n, false);
        }
        if (n2 > 0) {
            this.data[DSCompiler.getCompiler((int)n3, (int)n2).getSize()] = 1.0;
        }
    }

    public DerivativeStructure(double d, DerivativeStructure derivativeStructure, double d2, DerivativeStructure derivativeStructure2) {
        this(derivativeStructure.compiler);
        this.compiler.checkCompatibility(derivativeStructure2.compiler);
        this.compiler.linearCombination(d, derivativeStructure.data, 0, d2, derivativeStructure2.data, 0, this.data, 0);
    }

    public DerivativeStructure(double d, DerivativeStructure derivativeStructure, double d2, DerivativeStructure derivativeStructure2, double d3, DerivativeStructure derivativeStructure3) {
        this(derivativeStructure.compiler);
        this.compiler.checkCompatibility(derivativeStructure2.compiler);
        this.compiler.checkCompatibility(derivativeStructure3.compiler);
        this.compiler.linearCombination(d, derivativeStructure.data, 0, d2, derivativeStructure2.data, 0, d3, derivativeStructure3.data, 0, this.data, 0);
    }

    public DerivativeStructure(double d, DerivativeStructure derivativeStructure, double d2, DerivativeStructure derivativeStructure2, double d3, DerivativeStructure derivativeStructure3, double d4, DerivativeStructure derivativeStructure4) {
        this(derivativeStructure.compiler);
        this.compiler.checkCompatibility(derivativeStructure2.compiler);
        this.compiler.checkCompatibility(derivativeStructure3.compiler);
        this.compiler.checkCompatibility(derivativeStructure4.compiler);
        this.compiler.linearCombination(d, derivativeStructure.data, 0, d2, derivativeStructure2.data, 0, d3, derivativeStructure3.data, 0, d4, derivativeStructure4.data, 0, this.data, 0);
    }

    public DerivativeStructure(int n, int n2, double ... dArray) {
        this(n, n2);
        if (dArray.length != this.data.length) {
            throw new DimensionMismatchException(dArray.length, this.data.length);
        }
        System.arraycopy(dArray, 0, this.data, 0, this.data.length);
    }

    private DerivativeStructure(DerivativeStructure derivativeStructure) {
        this.compiler = derivativeStructure.compiler;
        this.data = (double[])derivativeStructure.data.clone();
    }

    public int getFreeParameters() {
        return this.compiler.getFreeParameters();
    }

    public int getOrder() {
        return this.compiler.getOrder();
    }

    public DerivativeStructure createConstant(double d) {
        return new DerivativeStructure(this.getFreeParameters(), this.getOrder(), d);
    }

    @Override
    public double getReal() {
        return this.data[0];
    }

    public double getValue() {
        return this.data[0];
    }

    public double getPartialDerivative(int ... nArray) {
        return this.data[this.compiler.getPartialDerivativeIndex(nArray)];
    }

    public double[] getAllDerivatives() {
        return (double[])this.data.clone();
    }

    @Override
    public DerivativeStructure add(double d) {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this);
        derivativeStructure.data[0] = derivativeStructure.data[0] + d;
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure add(DerivativeStructure derivativeStructure) {
        this.compiler.checkCompatibility(derivativeStructure.compiler);
        DerivativeStructure derivativeStructure2 = new DerivativeStructure(this);
        this.compiler.add(this.data, 0, derivativeStructure.data, 0, derivativeStructure2.data, 0);
        return derivativeStructure2;
    }

    @Override
    public DerivativeStructure subtract(double d) {
        return this.add(-d);
    }

    @Override
    public DerivativeStructure subtract(DerivativeStructure derivativeStructure) {
        this.compiler.checkCompatibility(derivativeStructure.compiler);
        DerivativeStructure derivativeStructure2 = new DerivativeStructure(this);
        this.compiler.subtract(this.data, 0, derivativeStructure.data, 0, derivativeStructure2.data, 0);
        return derivativeStructure2;
    }

    @Override
    public DerivativeStructure multiply(int n) {
        return this.multiply((double)n);
    }

    @Override
    public DerivativeStructure multiply(double d) {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this);
        int n = 0;
        while (n < derivativeStructure.data.length) {
            int n2 = n++;
            derivativeStructure.data[n2] = derivativeStructure.data[n2] * d;
        }
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure multiply(DerivativeStructure derivativeStructure) {
        this.compiler.checkCompatibility(derivativeStructure.compiler);
        DerivativeStructure derivativeStructure2 = new DerivativeStructure(this.compiler);
        this.compiler.multiply(this.data, 0, derivativeStructure.data, 0, derivativeStructure2.data, 0);
        return derivativeStructure2;
    }

    @Override
    public DerivativeStructure divide(double d) {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this);
        int n = 0;
        while (n < derivativeStructure.data.length) {
            int n2 = n++;
            derivativeStructure.data[n2] = derivativeStructure.data[n2] / d;
        }
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure divide(DerivativeStructure derivativeStructure) {
        this.compiler.checkCompatibility(derivativeStructure.compiler);
        DerivativeStructure derivativeStructure2 = new DerivativeStructure(this.compiler);
        this.compiler.divide(this.data, 0, derivativeStructure.data, 0, derivativeStructure2.data, 0);
        return derivativeStructure2;
    }

    @Override
    public DerivativeStructure remainder(double d) {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this);
        derivativeStructure.data[0] = FastMath.IEEEremainder(derivativeStructure.data[0], d);
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure remainder(DerivativeStructure derivativeStructure) {
        this.compiler.checkCompatibility(derivativeStructure.compiler);
        DerivativeStructure derivativeStructure2 = new DerivativeStructure(this.compiler);
        this.compiler.remainder(this.data, 0, derivativeStructure.data, 0, derivativeStructure2.data, 0);
        return derivativeStructure2;
    }

    @Override
    public DerivativeStructure negate() {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        for (int i = 0; i < derivativeStructure.data.length; ++i) {
            derivativeStructure.data[i] = -this.data[i];
        }
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure abs() {
        if (Double.doubleToLongBits(this.data[0]) < 0L) {
            return this.negate();
        }
        return this;
    }

    @Override
    public DerivativeStructure ceil() {
        return new DerivativeStructure(this.compiler.getFreeParameters(), this.compiler.getOrder(), FastMath.ceil(this.data[0]));
    }

    @Override
    public DerivativeStructure floor() {
        return new DerivativeStructure(this.compiler.getFreeParameters(), this.compiler.getOrder(), FastMath.floor(this.data[0]));
    }

    @Override
    public DerivativeStructure rint() {
        return new DerivativeStructure(this.compiler.getFreeParameters(), this.compiler.getOrder(), FastMath.rint(this.data[0]));
    }

    @Override
    public long round() {
        return FastMath.round(this.data[0]);
    }

    @Override
    public DerivativeStructure signum() {
        return new DerivativeStructure(this.compiler.getFreeParameters(), this.compiler.getOrder(), FastMath.signum(this.data[0]));
    }

    @Override
    public DerivativeStructure copySign(DerivativeStructure derivativeStructure) {
        long l = Double.doubleToLongBits(this.data[0]);
        long l2 = Double.doubleToLongBits(derivativeStructure.data[0]);
        if (l >= 0L && l2 >= 0L || l < 0L && l2 < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public DerivativeStructure copySign(double d) {
        long l = Double.doubleToLongBits(this.data[0]);
        long l2 = Double.doubleToLongBits(d);
        if (l >= 0L && l2 >= 0L || l < 0L && l2 < 0L) {
            return this;
        }
        return this.negate();
    }

    public int getExponent() {
        return FastMath.getExponent(this.data[0]);
    }

    @Override
    public DerivativeStructure scalb(int n) {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        for (int i = 0; i < derivativeStructure.data.length; ++i) {
            derivativeStructure.data[i] = FastMath.scalb(this.data[i], n);
        }
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure hypot(DerivativeStructure derivativeStructure) {
        int n;
        this.compiler.checkCompatibility(derivativeStructure.compiler);
        if (Double.isInfinite(this.data[0]) || Double.isInfinite(derivativeStructure.data[0])) {
            return new DerivativeStructure(this.compiler.getFreeParameters(), this.compiler.getFreeParameters(), Double.POSITIVE_INFINITY);
        }
        if (Double.isNaN(this.data[0]) || Double.isNaN(derivativeStructure.data[0])) {
            return new DerivativeStructure(this.compiler.getFreeParameters(), this.compiler.getFreeParameters(), Double.NaN);
        }
        int n2 = this.getExponent();
        if (n2 > (n = derivativeStructure.getExponent()) + 27) {
            return this.abs();
        }
        if (n > n2 + 27) {
            return derivativeStructure.abs();
        }
        int n3 = (n2 + n) / 2;
        DerivativeStructure derivativeStructure2 = this.scalb(-n3);
        DerivativeStructure derivativeStructure3 = derivativeStructure.scalb(-n3);
        DerivativeStructure derivativeStructure4 = derivativeStructure2.multiply(derivativeStructure2).add(derivativeStructure3.multiply(derivativeStructure3)).sqrt();
        return derivativeStructure4.scalb(n3);
    }

    public static DerivativeStructure hypot(DerivativeStructure derivativeStructure, DerivativeStructure derivativeStructure2) {
        return derivativeStructure.hypot(derivativeStructure2);
    }

    public DerivativeStructure compose(double ... dArray) {
        if (dArray.length != this.getOrder() + 1) {
            throw new DimensionMismatchException(dArray.length, this.getOrder() + 1);
        }
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        this.compiler.compose(this.data, 0, dArray, derivativeStructure.data, 0);
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure reciprocal() {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        this.compiler.pow(this.data, 0, -1, derivativeStructure.data, 0);
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure sqrt() {
        return this.rootN(2);
    }

    @Override
    public DerivativeStructure cbrt() {
        return this.rootN(3);
    }

    @Override
    public DerivativeStructure rootN(int n) {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        this.compiler.rootN(this.data, 0, n, derivativeStructure.data, 0);
        return derivativeStructure;
    }

    @Override
    public Field<DerivativeStructure> getField() {
        return new Field<DerivativeStructure>(){

            @Override
            public DerivativeStructure getZero() {
                return new DerivativeStructure(DerivativeStructure.this.compiler.getFreeParameters(), DerivativeStructure.this.compiler.getOrder(), 0.0);
            }

            @Override
            public DerivativeStructure getOne() {
                return new DerivativeStructure(DerivativeStructure.this.compiler.getFreeParameters(), DerivativeStructure.this.compiler.getOrder(), 1.0);
            }

            @Override
            public Class<? extends FieldElement<DerivativeStructure>> getRuntimeClass() {
                return DerivativeStructure.class;
            }
        };
    }

    public static DerivativeStructure pow(double d, DerivativeStructure derivativeStructure) {
        DerivativeStructure derivativeStructure2 = new DerivativeStructure(derivativeStructure.compiler);
        derivativeStructure.compiler.pow(d, derivativeStructure.data, 0, derivativeStructure2.data, 0);
        return derivativeStructure2;
    }

    @Override
    public DerivativeStructure pow(double d) {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        this.compiler.pow(this.data, 0, d, derivativeStructure.data, 0);
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure pow(int n) {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        this.compiler.pow(this.data, 0, n, derivativeStructure.data, 0);
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure pow(DerivativeStructure derivativeStructure) {
        this.compiler.checkCompatibility(derivativeStructure.compiler);
        DerivativeStructure derivativeStructure2 = new DerivativeStructure(this.compiler);
        this.compiler.pow(this.data, 0, derivativeStructure.data, 0, derivativeStructure2.data, 0);
        return derivativeStructure2;
    }

    @Override
    public DerivativeStructure exp() {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        this.compiler.exp(this.data, 0, derivativeStructure.data, 0);
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure expm1() {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        this.compiler.expm1(this.data, 0, derivativeStructure.data, 0);
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure log() {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        this.compiler.log(this.data, 0, derivativeStructure.data, 0);
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure log1p() {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        this.compiler.log1p(this.data, 0, derivativeStructure.data, 0);
        return derivativeStructure;
    }

    public DerivativeStructure log10() {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        this.compiler.log10(this.data, 0, derivativeStructure.data, 0);
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure cos() {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        this.compiler.cos(this.data, 0, derivativeStructure.data, 0);
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure sin() {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        this.compiler.sin(this.data, 0, derivativeStructure.data, 0);
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure tan() {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        this.compiler.tan(this.data, 0, derivativeStructure.data, 0);
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure acos() {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        this.compiler.acos(this.data, 0, derivativeStructure.data, 0);
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure asin() {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        this.compiler.asin(this.data, 0, derivativeStructure.data, 0);
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure atan() {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        this.compiler.atan(this.data, 0, derivativeStructure.data, 0);
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure atan2(DerivativeStructure derivativeStructure) {
        this.compiler.checkCompatibility(derivativeStructure.compiler);
        DerivativeStructure derivativeStructure2 = new DerivativeStructure(this.compiler);
        this.compiler.atan2(this.data, 0, derivativeStructure.data, 0, derivativeStructure2.data, 0);
        return derivativeStructure2;
    }

    public static DerivativeStructure atan2(DerivativeStructure derivativeStructure, DerivativeStructure derivativeStructure2) {
        return derivativeStructure.atan2(derivativeStructure2);
    }

    @Override
    public DerivativeStructure cosh() {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        this.compiler.cosh(this.data, 0, derivativeStructure.data, 0);
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure sinh() {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        this.compiler.sinh(this.data, 0, derivativeStructure.data, 0);
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure tanh() {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        this.compiler.tanh(this.data, 0, derivativeStructure.data, 0);
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure acosh() {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        this.compiler.acosh(this.data, 0, derivativeStructure.data, 0);
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure asinh() {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        this.compiler.asinh(this.data, 0, derivativeStructure.data, 0);
        return derivativeStructure;
    }

    @Override
    public DerivativeStructure atanh() {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        this.compiler.atanh(this.data, 0, derivativeStructure.data, 0);
        return derivativeStructure;
    }

    public DerivativeStructure toDegrees() {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        for (int i = 0; i < derivativeStructure.data.length; ++i) {
            derivativeStructure.data[i] = FastMath.toDegrees(this.data[i]);
        }
        return derivativeStructure;
    }

    public DerivativeStructure toRadians() {
        DerivativeStructure derivativeStructure = new DerivativeStructure(this.compiler);
        for (int i = 0; i < derivativeStructure.data.length; ++i) {
            derivativeStructure.data[i] = FastMath.toRadians(this.data[i]);
        }
        return derivativeStructure;
    }

    public double taylor(double ... dArray) {
        return this.compiler.taylor(this.data, 0, dArray);
    }

    public DerivativeStructure linearCombination(DerivativeStructure[] derivativeStructureArray, DerivativeStructure[] derivativeStructureArray2) {
        double[] dArray = new double[derivativeStructureArray.length];
        for (int i = 0; i < derivativeStructureArray.length; ++i) {
            dArray[i] = derivativeStructureArray[i].getValue();
        }
        double[] dArray2 = new double[derivativeStructureArray2.length];
        for (int i = 0; i < derivativeStructureArray2.length; ++i) {
            dArray2[i] = derivativeStructureArray2[i].getValue();
        }
        double d = MathArrays.linearCombination(dArray, dArray2);
        DerivativeStructure derivativeStructure = derivativeStructureArray[0].getField().getZero();
        for (int i = 0; i < derivativeStructureArray.length; ++i) {
            derivativeStructure = derivativeStructure.add(derivativeStructureArray[i].multiply(derivativeStructureArray2[i]));
        }
        double[] dArray3 = derivativeStructure.getAllDerivatives();
        dArray3[0] = d;
        return new DerivativeStructure(derivativeStructure.getFreeParameters(), derivativeStructure.getOrder(), dArray3);
    }

    public DerivativeStructure linearCombination(double[] dArray, DerivativeStructure[] derivativeStructureArray) {
        double[] dArray2 = new double[derivativeStructureArray.length];
        for (int i = 0; i < derivativeStructureArray.length; ++i) {
            dArray2[i] = derivativeStructureArray[i].getValue();
        }
        double d = MathArrays.linearCombination(dArray, dArray2);
        DerivativeStructure derivativeStructure = derivativeStructureArray[0].getField().getZero();
        for (int i = 0; i < dArray.length; ++i) {
            derivativeStructure = derivativeStructure.add(derivativeStructureArray[i].multiply(dArray[i]));
        }
        double[] dArray3 = derivativeStructure.getAllDerivatives();
        dArray3[0] = d;
        return new DerivativeStructure(derivativeStructure.getFreeParameters(), derivativeStructure.getOrder(), dArray3);
    }

    @Override
    public DerivativeStructure linearCombination(DerivativeStructure derivativeStructure, DerivativeStructure derivativeStructure2, DerivativeStructure derivativeStructure3, DerivativeStructure derivativeStructure4) {
        double d = MathArrays.linearCombination(derivativeStructure.getValue(), derivativeStructure2.getValue(), derivativeStructure3.getValue(), derivativeStructure4.getValue());
        DerivativeStructure derivativeStructure5 = derivativeStructure.multiply(derivativeStructure2).add(derivativeStructure3.multiply(derivativeStructure4));
        double[] dArray = derivativeStructure5.getAllDerivatives();
        dArray[0] = d;
        return new DerivativeStructure(this.getFreeParameters(), this.getOrder(), dArray);
    }

    @Override
    public DerivativeStructure linearCombination(double d, DerivativeStructure derivativeStructure, double d2, DerivativeStructure derivativeStructure2) {
        double d3 = MathArrays.linearCombination(d, derivativeStructure.getValue(), d2, derivativeStructure2.getValue());
        DerivativeStructure derivativeStructure3 = derivativeStructure.multiply(d).add(derivativeStructure2.multiply(d2));
        double[] dArray = derivativeStructure3.getAllDerivatives();
        dArray[0] = d3;
        return new DerivativeStructure(this.getFreeParameters(), this.getOrder(), dArray);
    }

    @Override
    public DerivativeStructure linearCombination(DerivativeStructure derivativeStructure, DerivativeStructure derivativeStructure2, DerivativeStructure derivativeStructure3, DerivativeStructure derivativeStructure4, DerivativeStructure derivativeStructure5, DerivativeStructure derivativeStructure6) {
        double d = MathArrays.linearCombination(derivativeStructure.getValue(), derivativeStructure2.getValue(), derivativeStructure3.getValue(), derivativeStructure4.getValue(), derivativeStructure5.getValue(), derivativeStructure6.getValue());
        DerivativeStructure derivativeStructure7 = derivativeStructure.multiply(derivativeStructure2).add(derivativeStructure3.multiply(derivativeStructure4)).add(derivativeStructure5.multiply(derivativeStructure6));
        double[] dArray = derivativeStructure7.getAllDerivatives();
        dArray[0] = d;
        return new DerivativeStructure(this.getFreeParameters(), this.getOrder(), dArray);
    }

    @Override
    public DerivativeStructure linearCombination(double d, DerivativeStructure derivativeStructure, double d2, DerivativeStructure derivativeStructure2, double d3, DerivativeStructure derivativeStructure3) {
        double d4 = MathArrays.linearCombination(d, derivativeStructure.getValue(), d2, derivativeStructure2.getValue(), d3, derivativeStructure3.getValue());
        DerivativeStructure derivativeStructure4 = derivativeStructure.multiply(d).add(derivativeStructure2.multiply(d2)).add(derivativeStructure3.multiply(d3));
        double[] dArray = derivativeStructure4.getAllDerivatives();
        dArray[0] = d4;
        return new DerivativeStructure(this.getFreeParameters(), this.getOrder(), dArray);
    }

    @Override
    public DerivativeStructure linearCombination(DerivativeStructure derivativeStructure, DerivativeStructure derivativeStructure2, DerivativeStructure derivativeStructure3, DerivativeStructure derivativeStructure4, DerivativeStructure derivativeStructure5, DerivativeStructure derivativeStructure6, DerivativeStructure derivativeStructure7, DerivativeStructure derivativeStructure8) {
        double d = MathArrays.linearCombination(derivativeStructure.getValue(), derivativeStructure2.getValue(), derivativeStructure3.getValue(), derivativeStructure4.getValue(), derivativeStructure5.getValue(), derivativeStructure6.getValue(), derivativeStructure7.getValue(), derivativeStructure8.getValue());
        DerivativeStructure derivativeStructure9 = derivativeStructure.multiply(derivativeStructure2).add(derivativeStructure3.multiply(derivativeStructure4)).add(derivativeStructure5.multiply(derivativeStructure6)).add(derivativeStructure7.multiply(derivativeStructure8));
        double[] dArray = derivativeStructure9.getAllDerivatives();
        dArray[0] = d;
        return new DerivativeStructure(this.getFreeParameters(), this.getOrder(), dArray);
    }

    @Override
    public DerivativeStructure linearCombination(double d, DerivativeStructure derivativeStructure, double d2, DerivativeStructure derivativeStructure2, double d3, DerivativeStructure derivativeStructure3, double d4, DerivativeStructure derivativeStructure4) {
        double d5 = MathArrays.linearCombination(d, derivativeStructure.getValue(), d2, derivativeStructure2.getValue(), d3, derivativeStructure3.getValue(), d4, derivativeStructure4.getValue());
        DerivativeStructure derivativeStructure5 = derivativeStructure.multiply(d).add(derivativeStructure2.multiply(d2)).add(derivativeStructure3.multiply(d3)).add(derivativeStructure4.multiply(d4));
        double[] dArray = derivativeStructure5.getAllDerivatives();
        dArray[0] = d5;
        return new DerivativeStructure(this.getFreeParameters(), this.getOrder(), dArray);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DerivativeStructure) {
            DerivativeStructure derivativeStructure = (DerivativeStructure)object;
            return this.getFreeParameters() == derivativeStructure.getFreeParameters() && this.getOrder() == derivativeStructure.getOrder() && MathArrays.equals(this.data, derivativeStructure.data);
        }
        return false;
    }

    public int hashCode() {
        return 227 + 229 * this.getFreeParameters() + 233 * this.getOrder() + 239 * MathUtils.hash(this.data);
    }

    private Object writeReplace() {
        return new DataTransferObject(this.compiler.getFreeParameters(), this.compiler.getOrder(), this.data);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20120730L;
        private final int variables;
        private final int order;
        private final double[] data;

        DataTransferObject(int n, int n2, double[] dArray) {
            this.variables = n;
            this.order = n2;
            this.data = dArray;
        }

        private Object readResolve() {
            return new DerivativeStructure(this.variables, this.order, this.data);
        }
    }
}

