/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.differentiation;

import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableFunction;

public class GradientFunction
implements MultivariateVectorFunction {
    private final MultivariateDifferentiableFunction f;

    public GradientFunction(MultivariateDifferentiableFunction multivariateDifferentiableFunction) {
        this.f = multivariateDifferentiableFunction;
    }

    public double[] value(double[] dArray) {
        DerivativeStructure[] derivativeStructureArray = new DerivativeStructure[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            derivativeStructureArray[i] = new DerivativeStructure(dArray.length, 1, i, dArray[i]);
        }
        DerivativeStructure derivativeStructure = this.f.value(derivativeStructureArray);
        double[] dArray2 = new double[dArray.length];
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = 1;
            dArray2[i] = derivativeStructure.getPartialDerivative(nArray);
            nArray[i] = 0;
        }
        return dArray2;
    }
}

