/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.differentiation;

import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableVectorFunction;

public class JacobianFunction
implements MultivariateMatrixFunction {
    private final MultivariateDifferentiableVectorFunction f;

    public JacobianFunction(MultivariateDifferentiableVectorFunction multivariateDifferentiableVectorFunction) {
        this.f = multivariateDifferentiableVectorFunction;
    }

    public double[][] value(double[] dArray) {
        DerivativeStructure[] derivativeStructureArray = new DerivativeStructure[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            derivativeStructureArray[i] = new DerivativeStructure(dArray.length, 1, i, dArray[i]);
        }
        DerivativeStructure[] derivativeStructureArray2 = this.f.value(derivativeStructureArray);
        double[][] dArray2 = new double[derivativeStructureArray2.length][dArray.length];
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < derivativeStructureArray2.length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                nArray[j] = 1;
                dArray2[i][j] = derivativeStructureArray2[i].getPartialDerivative(nArray);
                nArray[j] = 0;
            }
        }
        return dArray2;
    }
}

