/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.function;

import java.util.Arrays;
import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.util.FastMath;

public class Sigmoid
implements UnivariateDifferentiableFunction,
DifferentiableUnivariateFunction {
    private final double lo;
    private final double hi;

    public Sigmoid() {
        this(0.0, 1.0);
    }

    public Sigmoid(double d, double d2) {
        this.lo = d;
        this.hi = d2;
    }

    @Deprecated
    public UnivariateFunction derivative() {
        return FunctionUtils.toDifferentiableUnivariateFunction(this).derivative();
    }

    public double value(double d) {
        return Sigmoid.value(d, this.lo, this.hi);
    }

    private static double value(double d, double d2, double d3) {
        return d2 + (d3 - d2) / (1.0 + FastMath.exp(-d));
    }

    public DerivativeStructure value(DerivativeStructure derivativeStructure) {
        double[] dArray = new double[derivativeStructure.getOrder() + 1];
        double d = FastMath.exp(-derivativeStructure.getValue());
        if (Double.isInfinite(d)) {
            dArray[0] = this.lo;
            Arrays.fill(dArray, 1, dArray.length, 0.0);
        } else {
            double[] dArray2 = new double[dArray.length];
            double d2 = 1.0 / (1.0 + d);
            double d3 = this.hi - this.lo;
            for (int i = 0; i < dArray.length; ++i) {
                double d4 = 0.0;
                dArray2[i] = 1.0;
                for (int j = i; j >= 0; --j) {
                    d4 = d4 * d + dArray2[j];
                    if (j > 1) {
                        dArray2[j - 1] = (double)(i - j + 2) * dArray2[j - 2] - (double)(j - 1) * dArray2[j - 1];
                        continue;
                    }
                    dArray2[0] = 0.0;
                }
                dArray[i] = (d3 *= d2) * d4;
            }
            dArray[0] = dArray[0] + this.lo;
        }
        return derivativeStructure.compose(dArray);
    }

    public static class Parametric
    implements ParametricUnivariateFunction {
        public double value(double d, double ... dArray) {
            this.validateParameters(dArray);
            return Sigmoid.value(d, dArray[0], dArray[1]);
        }

        public double[] gradient(double d, double ... dArray) {
            this.validateParameters(dArray);
            double d2 = 1.0 / (1.0 + FastMath.exp(-d));
            return new double[]{1.0 - d2, d2};
        }

        private void validateParameters(double[] dArray) {
            if (dArray == null) {
                throw new NullArgumentException();
            }
            if (dArray.length != 2) {
                throw new DimensionMismatchException(dArray.length, 2);
            }
        }
    }
}

