/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.integration;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.integration.UnivariateIntegrator;
import org.apache.commons.math3.analysis.solvers.UnivariateSolverUtils;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.util.Incrementor;
import org.apache.commons.math3.util.IntegerSequence;
import org.apache.commons.math3.util.MathUtils;

public abstract class BaseAbstractUnivariateIntegrator
implements UnivariateIntegrator {
    public static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-15;
    public static final double DEFAULT_RELATIVE_ACCURACY = 1.0E-6;
    public static final int DEFAULT_MIN_ITERATIONS_COUNT = 3;
    public static final int DEFAULT_MAX_ITERATIONS_COUNT = Integer.MAX_VALUE;
    @Deprecated
    protected Incrementor iterations;
    private IntegerSequence.Incrementor count;
    private final double absoluteAccuracy;
    private final double relativeAccuracy;
    private final int minimalIterationCount;
    private IntegerSequence.Incrementor evaluations;
    private UnivariateFunction function;
    private double min;
    private double max;

    protected BaseAbstractUnivariateIntegrator(double d, double d2, int n, int n2) {
        Incrementor incrementor;
        this.relativeAccuracy = d;
        this.absoluteAccuracy = d2;
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        if (n2 <= n) {
            throw new NumberIsTooSmallException(n2, (Number)n, false);
        }
        this.minimalIterationCount = n;
        this.count = IntegerSequence.Incrementor.create().withMaximalCount(n2);
        this.iterations = incrementor = Incrementor.wrap(this.count);
        this.evaluations = IntegerSequence.Incrementor.create();
    }

    protected BaseAbstractUnivariateIntegrator(double d, double d2) {
        this(d, d2, 3, Integer.MAX_VALUE);
    }

    protected BaseAbstractUnivariateIntegrator(int n, int n2) {
        this(1.0E-6, 1.0E-15, n, n2);
    }

    public double getRelativeAccuracy() {
        return this.relativeAccuracy;
    }

    public double getAbsoluteAccuracy() {
        return this.absoluteAccuracy;
    }

    public int getMinimalIterationCount() {
        return this.minimalIterationCount;
    }

    public int getMaximalIterationCount() {
        return this.count.getMaximalCount();
    }

    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    public int getIterations() {
        return this.count.getCount();
    }

    protected void incrementCount() {
        this.count.increment();
    }

    protected double getMin() {
        return this.min;
    }

    protected double getMax() {
        return this.max;
    }

    protected double computeObjectiveValue(double d) {
        try {
            this.evaluations.increment();
        }
        catch (MaxCountExceededException maxCountExceededException) {
            throw new TooManyEvaluationsException(maxCountExceededException.getMax());
        }
        return this.function.value(d);
    }

    protected void setup(int n, UnivariateFunction univariateFunction, double d, double d2) {
        MathUtils.checkNotNull(univariateFunction);
        UnivariateSolverUtils.verifyInterval(d, d2);
        this.min = d;
        this.max = d2;
        this.function = univariateFunction;
        this.evaluations = this.evaluations.withMaximalCount(n).withStart(0);
        this.count = this.count.withStart(0);
    }

    public double integrate(int n, UnivariateFunction univariateFunction, double d, double d2) {
        this.setup(n, univariateFunction, d, d2);
        return this.doIntegrate();
    }

    protected abstract double doIntegrate();
}

