/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.integration;

import org.apache.commons.math3.analysis.integration.BaseAbstractUnivariateIntegrator;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;

@Deprecated
public class LegendreGaussIntegrator
extends BaseAbstractUnivariateIntegrator {
    private static final double[] ABSCISSAS_2 = new double[]{-1.0 / FastMath.sqrt(3.0), 1.0 / FastMath.sqrt(3.0)};
    private static final double[] WEIGHTS_2 = new double[]{1.0, 1.0};
    private static final double[] ABSCISSAS_3 = new double[]{-FastMath.sqrt(0.6), 0.0, FastMath.sqrt(0.6)};
    private static final double[] WEIGHTS_3 = new double[]{0.5555555555555556, 0.8888888888888888, 0.5555555555555556};
    private static final double[] ABSCISSAS_4 = new double[]{-FastMath.sqrt((15.0 + 2.0 * FastMath.sqrt(30.0)) / 35.0), -FastMath.sqrt((15.0 - 2.0 * FastMath.sqrt(30.0)) / 35.0), FastMath.sqrt((15.0 - 2.0 * FastMath.sqrt(30.0)) / 35.0), FastMath.sqrt((15.0 + 2.0 * FastMath.sqrt(30.0)) / 35.0)};
    private static final double[] WEIGHTS_4 = new double[]{(90.0 - 5.0 * FastMath.sqrt(30.0)) / 180.0, (90.0 + 5.0 * FastMath.sqrt(30.0)) / 180.0, (90.0 + 5.0 * FastMath.sqrt(30.0)) / 180.0, (90.0 - 5.0 * FastMath.sqrt(30.0)) / 180.0};
    private static final double[] ABSCISSAS_5 = new double[]{-FastMath.sqrt((35.0 + 2.0 * FastMath.sqrt(70.0)) / 63.0), -FastMath.sqrt((35.0 - 2.0 * FastMath.sqrt(70.0)) / 63.0), 0.0, FastMath.sqrt((35.0 - 2.0 * FastMath.sqrt(70.0)) / 63.0), FastMath.sqrt((35.0 + 2.0 * FastMath.sqrt(70.0)) / 63.0)};
    private static final double[] WEIGHTS_5 = new double[]{(322.0 - 13.0 * FastMath.sqrt(70.0)) / 900.0, (322.0 + 13.0 * FastMath.sqrt(70.0)) / 900.0, 0.5688888888888889, (322.0 + 13.0 * FastMath.sqrt(70.0)) / 900.0, (322.0 - 13.0 * FastMath.sqrt(70.0)) / 900.0};
    private final double[] abscissas;
    private final double[] weights;

    public LegendreGaussIntegrator(int n, double d, double d2, int n2, int n3) {
        super(d, d2, n2, n3);
        switch (n) {
            case 2: {
                this.abscissas = ABSCISSAS_2;
                this.weights = WEIGHTS_2;
                break;
            }
            case 3: {
                this.abscissas = ABSCISSAS_3;
                this.weights = WEIGHTS_3;
                break;
            }
            case 4: {
                this.abscissas = ABSCISSAS_4;
                this.weights = WEIGHTS_4;
                break;
            }
            case 5: {
                this.abscissas = ABSCISSAS_5;
                this.weights = WEIGHTS_5;
                break;
            }
            default: {
                throw new MathIllegalArgumentException(LocalizedFormats.N_POINTS_GAUSS_LEGENDRE_INTEGRATOR_NOT_SUPPORTED, n, 2, 5);
            }
        }
    }

    public LegendreGaussIntegrator(int n, double d, double d2) {
        this(n, d, d2, 3, Integer.MAX_VALUE);
    }

    public LegendreGaussIntegrator(int n, int n2, int n3) {
        this(n, 1.0E-6, 1.0E-15, n2, n3);
    }

    protected double doIntegrate() {
        double d = this.stage(1);
        int n = 2;
        while (true) {
            double d2 = this.stage(n);
            double d3 = FastMath.abs(d2 - d);
            double d4 = FastMath.max(this.getAbsoluteAccuracy(), this.getRelativeAccuracy() * (FastMath.abs(d) + FastMath.abs(d2)) * 0.5);
            if (this.getIterations() + 1 >= this.getMinimalIterationCount() && d3 <= d4) {
                return d2;
            }
            double d5 = FastMath.min(4.0, FastMath.pow(d3 / d4, 0.5 / (double)this.abscissas.length));
            n = FastMath.max((int)(d5 * (double)n), n + 1);
            d = d2;
            this.incrementCount();
        }
    }

    private double stage(int n) {
        double d = (this.getMax() - this.getMin()) / (double)n;
        double d2 = d / 2.0;
        double d3 = this.getMin() + d2;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.abscissas.length; ++j) {
                d4 += this.weights[j] * this.computeObjectiveValue(d3 + d2 * this.abscissas[j]);
            }
            d3 += d;
        }
        return d2 * d4;
    }
}

