/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.integration;

import org.apache.commons.math3.analysis.integration.BaseAbstractUnivariateIntegrator;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.util.FastMath;

public class MidPointIntegrator
extends BaseAbstractUnivariateIntegrator {
    public static final int MIDPOINT_MAX_ITERATIONS_COUNT = 64;

    public MidPointIntegrator(double d, double d2, int n, int n2) {
        super(d, d2, n, n2);
        if (n2 > 64) {
            throw new NumberIsTooLargeException(n2, (Number)64, false);
        }
    }

    public MidPointIntegrator(int n, int n2) {
        super(n, n2);
        if (n2 > 64) {
            throw new NumberIsTooLargeException(n2, (Number)64, false);
        }
    }

    public MidPointIntegrator() {
        super(3, 64);
    }

    private double stage(int n, double d, double d2, double d3) {
        long l = 1L << n - 1;
        double d4 = 0.0;
        double d5 = d3 / (double)l;
        double d6 = d2 + 0.5 * d5;
        for (long i = 0L; i < l; ++i) {
            d4 += this.computeObjectiveValue(d6);
            d6 += d5;
        }
        return 0.5 * (d + d4 * d5);
    }

    protected double doIntegrate() {
        double d = this.getMin();
        double d2 = this.getMax() - d;
        double d3 = d + 0.5 * d2;
        double d4 = d2 * this.computeObjectiveValue(d3);
        while (true) {
            double d5;
            double d6;
            this.incrementCount();
            int n = this.getIterations();
            double d7 = this.stage(n, d4, d, d2);
            if (n >= this.getMinimalIterationCount() && ((d6 = FastMath.abs(d7 - d4)) <= (d5 = this.getRelativeAccuracy() * (FastMath.abs(d4) + FastMath.abs(d7)) * 0.5) || d6 <= this.getAbsoluteAccuracy())) {
                return d7;
            }
            d4 = d7;
        }
    }
}

