/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.integration;

import org.apache.commons.math3.analysis.integration.BaseAbstractUnivariateIntegrator;
import org.apache.commons.math3.analysis.integration.TrapezoidIntegrator;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.util.FastMath;

public class RombergIntegrator
extends BaseAbstractUnivariateIntegrator {
    public static final int ROMBERG_MAX_ITERATIONS_COUNT = 32;

    public RombergIntegrator(double d, double d2, int n, int n2) {
        super(d, d2, n, n2);
        if (n2 > 32) {
            throw new NumberIsTooLargeException(n2, (Number)32, false);
        }
    }

    public RombergIntegrator(int n, int n2) {
        super(n, n2);
        if (n2 > 32) {
            throw new NumberIsTooLargeException(n2, (Number)32, false);
        }
    }

    public RombergIntegrator() {
        super(3, 32);
    }

    protected double doIntegrate() {
        int n = this.getMaximalIterationCount() + 1;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        TrapezoidIntegrator trapezoidIntegrator = new TrapezoidIntegrator();
        dArray2[0] = trapezoidIntegrator.stage(this, 0);
        this.incrementCount();
        double d = dArray2[0];
        while (true) {
            double d2;
            double d3;
            int n2 = this.getIterations();
            double[] dArray3 = dArray;
            dArray = dArray2;
            dArray2 = dArray3;
            dArray2[0] = trapezoidIntegrator.stage(this, n2);
            this.incrementCount();
            for (int i = 1; i <= n2; ++i) {
                double d4 = (1L << 2 * i) - 1L;
                double d5 = dArray2[i - 1];
                dArray2[i] = d5 + (d5 - dArray[i - 1]) / d4;
            }
            double d6 = dArray2[n2];
            if (n2 >= this.getMinimalIterationCount() && ((d3 = FastMath.abs(d6 - d)) <= (d2 = this.getRelativeAccuracy() * (FastMath.abs(d) + FastMath.abs(d6)) * 0.5) || d3 <= this.getAbsoluteAccuracy())) {
                return d6;
            }
            d = d6;
        }
    }
}

