/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.integration;

import org.apache.commons.math3.analysis.integration.BaseAbstractUnivariateIntegrator;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.util.FastMath;

public class TrapezoidIntegrator
extends BaseAbstractUnivariateIntegrator {
    public static final int TRAPEZOID_MAX_ITERATIONS_COUNT = 64;
    private double s;

    public TrapezoidIntegrator(double d, double d2, int n, int n2) {
        super(d, d2, n, n2);
        if (n2 > 64) {
            throw new NumberIsTooLargeException(n2, (Number)64, false);
        }
    }

    public TrapezoidIntegrator(int n, int n2) {
        super(n, n2);
        if (n2 > 64) {
            throw new NumberIsTooLargeException(n2, (Number)64, false);
        }
    }

    public TrapezoidIntegrator() {
        super(3, 64);
    }

    double stage(BaseAbstractUnivariateIntegrator baseAbstractUnivariateIntegrator, int n) {
        if (n == 0) {
            double d = baseAbstractUnivariateIntegrator.getMax();
            double d2 = baseAbstractUnivariateIntegrator.getMin();
            this.s = 0.5 * (d - d2) * (baseAbstractUnivariateIntegrator.computeObjectiveValue(d2) + baseAbstractUnivariateIntegrator.computeObjectiveValue(d));
            return this.s;
        }
        long l = 1L << n - 1;
        double d = 0.0;
        double d3 = baseAbstractUnivariateIntegrator.getMax();
        double d4 = baseAbstractUnivariateIntegrator.getMin();
        double d5 = (d3 - d4) / (double)l;
        double d6 = d4 + 0.5 * d5;
        for (long i = 0L; i < l; ++i) {
            d += baseAbstractUnivariateIntegrator.computeObjectiveValue(d6);
            d6 += d5;
        }
        this.s = 0.5 * (this.s + d * d5);
        return this.s;
    }

    protected double doIntegrate() {
        double d = this.stage(this, 0);
        this.incrementCount();
        while (true) {
            double d2;
            double d3;
            int n = this.getIterations();
            double d4 = this.stage(this, n);
            if (n >= this.getMinimalIterationCount() && ((d3 = FastMath.abs(d4 - d)) <= (d2 = this.getRelativeAccuracy() * (FastMath.abs(d) + FastMath.abs(d4)) * 0.5) || d3 <= this.getAbsoluteAccuracy())) {
                return d4;
            }
            d = d4;
            this.incrementCount();
        }
    }
}

