/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.integration.gauss;

import org.apache.commons.math3.analysis.integration.gauss.BaseRuleFactory;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HermiteRuleFactory
extends BaseRuleFactory<Double> {
    private static final double SQRT_PI = 1.772453850905516;
    private static final double H0 = 0.7511255444649425;
    private static final double H1 = 1.0622519320271968;

    @Override
    protected Pair<Double[], Double[]> computeRule(int n) {
        double d;
        if (n == 1) {
            return new Pair<Double[], Double[]>(new Double[]{0.0}, new Double[]{1.772453850905516});
        }
        int n2 = n - 1;
        Double[] doubleArray = (Double[])this.getRuleInternal(n2).getFirst();
        Double[] doubleArray2 = new Double[n];
        Double[] doubleArray3 = new Double[n];
        double d2 = FastMath.sqrt(2 * n2);
        double d3 = FastMath.sqrt(2 * n);
        int n3 = n / 2;
        for (int i = 0; i < n3; ++i) {
            double d4;
            double d5;
            double d6 = i == 0 ? -d2 : doubleArray[i - 1];
            d = n3 == 1 ? -0.5 : doubleArray[i];
            double d7 = 0.7511255444649425;
            double d8 = 1.0622519320271968 * d6;
            double d9 = 0.7511255444649425;
            double d10 = 1.0622519320271968 * d;
            for (int j = 1; j < n; ++j) {
                double d11 = j + 1;
                double d12 = FastMath.sqrt(2.0 / d11);
                double d13 = FastMath.sqrt((double)j / d11);
                d5 = d12 * d6 * d8 - d13 * d7;
                d4 = d12 * d * d10 - d13 * d9;
                d7 = d8;
                d8 = d5;
                d9 = d10;
                d10 = d4;
            }
            double d14 = 0.5 * (d6 + d);
            double d15 = 0.7511255444649425;
            double d16 = 1.0622519320271968 * d14;
            boolean bl = false;
            while (!bl) {
                bl = d - d6 <= Math.ulp(d14);
                d15 = 0.7511255444649425;
                d16 = 1.0622519320271968 * d14;
                for (int j = 1; j < n; ++j) {
                    double d17 = j + 1;
                    double d18 = FastMath.sqrt(2.0 / d17);
                    double d19 = FastMath.sqrt((double)j / d17);
                    double d20 = d18 * d14 * d16 - d19 * d15;
                    d15 = d16;
                    d16 = d20;
                }
                if (bl) continue;
                if (d8 * d16 < 0.0) {
                    d = d14;
                    d9 = d15;
                    d10 = d16;
                } else {
                    d6 = d14;
                    d7 = d15;
                    d8 = d16;
                }
                d14 = 0.5 * (d6 + d);
            }
            d5 = d3 * d15;
            d4 = 2.0 / (d5 * d5);
            doubleArray2[i] = d14;
            doubleArray3[i] = d4;
            int n4 = n2 - i;
            doubleArray2[n4] = -d14;
            doubleArray3[n4] = d4;
        }
        if (n % 2 != 0) {
            double d21 = 0.7511255444649425;
            for (int i = 1; i < n; i += 2) {
                d = i + 1;
                d21 = -FastMath.sqrt((double)i / d) * d21;
            }
            double d22 = d3 * d21;
            double d23 = 2.0 / (d22 * d22);
            doubleArray2[n3] = 0.0;
            doubleArray3[n3] = d23;
        }
        return new Pair<Double[], Double[]>(doubleArray2, doubleArray3);
    }
}

