/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.BivariateFunction;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.util.MathArrays;

class BicubicFunction
implements BivariateFunction {
    private static final short N = 4;
    private final double[][] a = new double[4][4];

    BicubicFunction(double[] dArray) {
        for (int i = 0; i < 4; ++i) {
            double[] dArray2 = this.a[i];
            for (int j = 0; j < 4; ++j) {
                dArray2[j] = dArray[j * 4 + i];
            }
        }
    }

    public double value(double d, double d2) {
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException(d, (Number)0, 1);
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        double d3 = d * d;
        double d4 = d3 * d;
        double[] dArray = new double[]{1.0, d, d3, d4};
        double d5 = d2 * d2;
        double d6 = d5 * d2;
        double[] dArray2 = new double[]{1.0, d2, d5, d6};
        return this.apply(dArray, dArray2, this.a);
    }

    private double apply(double[] dArray, double[] dArray2, double[][] dArray3) {
        double d = 0.0;
        for (int i = 0; i < 4; ++i) {
            double d2 = MathArrays.linearCombination(dArray3[i], dArray2);
            d += d2 * dArray[i];
        }
        return d;
    }
}

