/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import java.util.Arrays;
import org.apache.commons.math3.analysis.BivariateFunction;
import org.apache.commons.math3.analysis.interpolation.BicubicFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.util.MathArrays;

public class BicubicInterpolatingFunction
implements BivariateFunction {
    private static final int NUM_COEFF = 16;
    private static final double[][] AINV = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {-3.0, 3.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {2.0, -2.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.0, 3.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, -2.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0}, {-3.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, -3.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, -1.0, 0.0}, {9.0, -9.0, -9.0, 9.0, 6.0, 3.0, -6.0, -3.0, 6.0, -6.0, 3.0, -3.0, 4.0, 2.0, 2.0, 1.0}, {-6.0, 6.0, 6.0, -6.0, -3.0, -3.0, 3.0, 3.0, -4.0, 4.0, -2.0, 2.0, -2.0, -2.0, -1.0, -1.0}, {2.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 2.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0}, {-6.0, 6.0, 6.0, -6.0, -4.0, -2.0, 4.0, 2.0, -3.0, 3.0, -3.0, 3.0, -2.0, -1.0, -2.0, -1.0}, {4.0, -4.0, -4.0, 4.0, 2.0, 2.0, -2.0, -2.0, 2.0, -2.0, 2.0, -2.0, 1.0, 1.0, 1.0, 1.0}};
    private final double[] xval;
    private final double[] yval;
    private final BicubicFunction[][] splines;

    public BicubicInterpolatingFunction(double[] dArray, double[] dArray2, double[][] dArray3, double[][] dArray4, double[][] dArray5, double[][] dArray6) {
        int n = dArray.length;
        int n2 = dArray2.length;
        if (n == 0 || n2 == 0 || dArray3.length == 0 || dArray3[0].length == 0) {
            throw new NoDataException();
        }
        if (n != dArray3.length) {
            throw new DimensionMismatchException(n, dArray3.length);
        }
        if (n != dArray4.length) {
            throw new DimensionMismatchException(n, dArray4.length);
        }
        if (n != dArray5.length) {
            throw new DimensionMismatchException(n, dArray5.length);
        }
        if (n != dArray6.length) {
            throw new DimensionMismatchException(n, dArray6.length);
        }
        MathArrays.checkOrder(dArray);
        MathArrays.checkOrder(dArray2);
        this.xval = (double[])dArray.clone();
        this.yval = (double[])dArray2.clone();
        int n3 = n - 1;
        int n4 = n2 - 1;
        this.splines = new BicubicFunction[n3][n4];
        for (int i = 0; i < n3; ++i) {
            if (dArray3[i].length != n2) {
                throw new DimensionMismatchException(dArray3[i].length, n2);
            }
            if (dArray4[i].length != n2) {
                throw new DimensionMismatchException(dArray4[i].length, n2);
            }
            if (dArray5[i].length != n2) {
                throw new DimensionMismatchException(dArray5[i].length, n2);
            }
            if (dArray6[i].length != n2) {
                throw new DimensionMismatchException(dArray6[i].length, n2);
            }
            int n5 = i + 1;
            double d = this.xval[n5] - this.xval[i];
            for (int j = 0; j < n4; ++j) {
                int n6 = j + 1;
                double d2 = this.yval[n6] - this.yval[j];
                double d3 = d * d2;
                double[] dArray7 = new double[]{dArray3[i][j], dArray3[n5][j], dArray3[i][n6], dArray3[n5][n6], dArray4[i][j] * d, dArray4[n5][j] * d, dArray4[i][n6] * d, dArray4[n5][n6] * d, dArray5[i][j] * d2, dArray5[n5][j] * d2, dArray5[i][n6] * d2, dArray5[n5][n6] * d2, dArray6[i][j] * d3, dArray6[n5][j] * d3, dArray6[i][n6] * d3, dArray6[n5][n6] * d3};
                this.splines[i][j] = new BicubicFunction(this.computeSplineCoefficients(dArray7));
            }
        }
    }

    public double value(double d, double d2) {
        int n = this.searchIndex(d, this.xval);
        int n2 = this.searchIndex(d2, this.yval);
        double d3 = (d - this.xval[n]) / (this.xval[n + 1] - this.xval[n]);
        double d4 = (d2 - this.yval[n2]) / (this.yval[n2 + 1] - this.yval[n2]);
        return this.splines[n][n2].value(d3, d4);
    }

    public boolean isValidPoint(double d, double d2) {
        return !(d < this.xval[0] || d > this.xval[this.xval.length - 1] || d2 < this.yval[0]) && !(d2 > this.yval[this.yval.length - 1]);
    }

    private int searchIndex(double d, double[] dArray) {
        int n = Arrays.binarySearch(dArray, d);
        if (n == -1 || n == -dArray.length - 1) {
            throw new OutOfRangeException(d, (Number)dArray[0], dArray[dArray.length - 1]);
        }
        if (n < 0) {
            return -n - 2;
        }
        int n2 = dArray.length - 1;
        if (n == n2) {
            return n2 - 1;
        }
        return n;
    }

    private double[] computeSplineCoefficients(double[] dArray) {
        double[] dArray2 = new double[16];
        for (int i = 0; i < 16; ++i) {
            double d = 0.0;
            double[] dArray3 = AINV[i];
            for (int j = 0; j < 16; ++j) {
                d += dArray3[j] * dArray[j];
            }
            dArray2[i] = d;
        }
        return dArray2;
    }
}

