/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import java.util.Arrays;
import org.apache.commons.math3.analysis.BivariateFunction;
import org.apache.commons.math3.analysis.interpolation.BicubicSplineFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.util.MathArrays;

@Deprecated
public class BicubicSplineInterpolatingFunction
implements BivariateFunction {
    private static final int NUM_COEFF = 16;
    private static final double[][] AINV = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {-3.0, 3.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {2.0, -2.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.0, 3.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, -2.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0}, {-3.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, -3.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, -1.0, 0.0}, {9.0, -9.0, -9.0, 9.0, 6.0, 3.0, -6.0, -3.0, 6.0, -6.0, 3.0, -3.0, 4.0, 2.0, 2.0, 1.0}, {-6.0, 6.0, 6.0, -6.0, -3.0, -3.0, 3.0, 3.0, -4.0, 4.0, -2.0, 2.0, -2.0, -2.0, -1.0, -1.0}, {2.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 2.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0}, {-6.0, 6.0, 6.0, -6.0, -4.0, -2.0, 4.0, 2.0, -3.0, 3.0, -3.0, 3.0, -2.0, -1.0, -2.0, -1.0}, {4.0, -4.0, -4.0, 4.0, 2.0, 2.0, -2.0, -2.0, 2.0, -2.0, 2.0, -2.0, 1.0, 1.0, 1.0, 1.0}};
    private final double[] xval;
    private final double[] yval;
    private final BicubicSplineFunction[][] splines;
    private final BivariateFunction[][][] partialDerivatives;

    public BicubicSplineInterpolatingFunction(double[] dArray, double[] dArray2, double[][] dArray3, double[][] dArray4, double[][] dArray5, double[][] dArray6) {
        this(dArray, dArray2, dArray3, dArray4, dArray5, dArray6, false);
    }

    public BicubicSplineInterpolatingFunction(double[] dArray, double[] dArray2, double[][] dArray3, double[][] dArray4, double[][] dArray5, double[][] dArray6, boolean bl) {
        int n;
        int n2;
        int n3 = dArray.length;
        int n4 = dArray2.length;
        if (n3 == 0 || n4 == 0 || dArray3.length == 0 || dArray3[0].length == 0) {
            throw new NoDataException();
        }
        if (n3 != dArray3.length) {
            throw new DimensionMismatchException(n3, dArray3.length);
        }
        if (n3 != dArray4.length) {
            throw new DimensionMismatchException(n3, dArray4.length);
        }
        if (n3 != dArray5.length) {
            throw new DimensionMismatchException(n3, dArray5.length);
        }
        if (n3 != dArray6.length) {
            throw new DimensionMismatchException(n3, dArray6.length);
        }
        MathArrays.checkOrder(dArray);
        MathArrays.checkOrder(dArray2);
        this.xval = (double[])dArray.clone();
        this.yval = (double[])dArray2.clone();
        int n5 = n3 - 1;
        int n6 = n4 - 1;
        this.splines = new BicubicSplineFunction[n5][n6];
        for (n2 = 0; n2 < n5; ++n2) {
            if (dArray3[n2].length != n4) {
                throw new DimensionMismatchException(dArray3[n2].length, n4);
            }
            if (dArray4[n2].length != n4) {
                throw new DimensionMismatchException(dArray4[n2].length, n4);
            }
            if (dArray5[n2].length != n4) {
                throw new DimensionMismatchException(dArray5[n2].length, n4);
            }
            if (dArray6[n2].length != n4) {
                throw new DimensionMismatchException(dArray6[n2].length, n4);
            }
            n = n2 + 1;
            for (int i = 0; i < n6; ++i) {
                int n7 = i + 1;
                double[] dArray7 = new double[]{dArray3[n2][i], dArray3[n][i], dArray3[n2][n7], dArray3[n][n7], dArray4[n2][i], dArray4[n][i], dArray4[n2][n7], dArray4[n][n7], dArray5[n2][i], dArray5[n][i], dArray5[n2][n7], dArray5[n][n7], dArray6[n2][i], dArray6[n][i], dArray6[n2][n7], dArray6[n][n7]};
                this.splines[n2][i] = new BicubicSplineFunction(this.computeSplineCoefficients(dArray7), bl);
            }
        }
        if (bl) {
            this.partialDerivatives = new BivariateFunction[5][n5][n6];
            for (n2 = 0; n2 < n5; ++n2) {
                for (n = 0; n < n6; ++n) {
                    BicubicSplineFunction bicubicSplineFunction = this.splines[n2][n];
                    this.partialDerivatives[0][n2][n] = bicubicSplineFunction.partialDerivativeX();
                    this.partialDerivatives[1][n2][n] = bicubicSplineFunction.partialDerivativeY();
                    this.partialDerivatives[2][n2][n] = bicubicSplineFunction.partialDerivativeXX();
                    this.partialDerivatives[3][n2][n] = bicubicSplineFunction.partialDerivativeYY();
                    this.partialDerivatives[4][n2][n] = bicubicSplineFunction.partialDerivativeXY();
                }
            }
        } else {
            this.partialDerivatives = null;
        }
    }

    public double value(double d, double d2) {
        int n = this.searchIndex(d, this.xval);
        int n2 = this.searchIndex(d2, this.yval);
        double d3 = (d - this.xval[n]) / (this.xval[n + 1] - this.xval[n]);
        double d4 = (d2 - this.yval[n2]) / (this.yval[n2 + 1] - this.yval[n2]);
        return this.splines[n][n2].value(d3, d4);
    }

    public boolean isValidPoint(double d, double d2) {
        return !(d < this.xval[0] || d > this.xval[this.xval.length - 1] || d2 < this.yval[0]) && !(d2 > this.yval[this.yval.length - 1]);
    }

    public double partialDerivativeX(double d, double d2) {
        return this.partialDerivative(0, d, d2);
    }

    public double partialDerivativeY(double d, double d2) {
        return this.partialDerivative(1, d, d2);
    }

    public double partialDerivativeXX(double d, double d2) {
        return this.partialDerivative(2, d, d2);
    }

    public double partialDerivativeYY(double d, double d2) {
        return this.partialDerivative(3, d, d2);
    }

    public double partialDerivativeXY(double d, double d2) {
        return this.partialDerivative(4, d, d2);
    }

    private double partialDerivative(int n, double d, double d2) {
        int n2 = this.searchIndex(d, this.xval);
        int n3 = this.searchIndex(d2, this.yval);
        double d3 = (d - this.xval[n2]) / (this.xval[n2 + 1] - this.xval[n2]);
        double d4 = (d2 - this.yval[n3]) / (this.yval[n3 + 1] - this.yval[n3]);
        return this.partialDerivatives[n][n2][n3].value(d3, d4);
    }

    private int searchIndex(double d, double[] dArray) {
        int n = Arrays.binarySearch(dArray, d);
        if (n == -1 || n == -dArray.length - 1) {
            throw new OutOfRangeException(d, (Number)dArray[0], dArray[dArray.length - 1]);
        }
        if (n < 0) {
            return -n - 2;
        }
        int n2 = dArray.length - 1;
        if (n == n2) {
            return n2 - 1;
        }
        return n;
    }

    private double[] computeSplineCoefficients(double[] dArray) {
        double[] dArray2 = new double[16];
        for (int i = 0; i < 16; ++i) {
            double d = 0.0;
            double[] dArray3 = AINV[i];
            for (int j = 0; j < 16; ++j) {
                d += dArray3[j] * dArray[j];
            }
            dArray2[i] = d;
        }
        return dArray2;
    }
}

