/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.BicubicSplineInterpolatingFunction;
import org.apache.commons.math3.analysis.interpolation.BivariateGridInterpolator;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.util.MathArrays;

@Deprecated
public class BicubicSplineInterpolator
implements BivariateGridInterpolator {
    private final boolean initializeDerivatives;

    public BicubicSplineInterpolator() {
        this(false);
    }

    public BicubicSplineInterpolator(boolean bl) {
        this.initializeDerivatives = bl;
    }

    public BicubicSplineInterpolatingFunction interpolate(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n;
        if (dArray.length == 0 || dArray2.length == 0 || dArray3.length == 0) {
            throw new NoDataException();
        }
        if (dArray.length != dArray3.length) {
            throw new DimensionMismatchException(dArray.length, dArray3.length);
        }
        MathArrays.checkOrder(dArray);
        MathArrays.checkOrder(dArray2);
        int n2 = dArray.length;
        int n3 = dArray2.length;
        double[][] dArray4 = new double[n3][n2];
        for (int i = 0; i < n2; ++i) {
            if (dArray3[i].length != n3) {
                throw new DimensionMismatchException(dArray3[i].length, n3);
            }
            for (int j = 0; j < n3; ++j) {
                dArray4[j][i] = dArray3[i][j];
            }
        }
        SplineInterpolator splineInterpolator = new SplineInterpolator();
        PolynomialSplineFunction[] polynomialSplineFunctionArray = new PolynomialSplineFunction[n3];
        for (int i = 0; i < n3; ++i) {
            polynomialSplineFunctionArray[i] = splineInterpolator.interpolate(dArray, dArray4[i]);
        }
        PolynomialSplineFunction[] polynomialSplineFunctionArray2 = new PolynomialSplineFunction[n2];
        for (int i = 0; i < n2; ++i) {
            polynomialSplineFunctionArray2[i] = splineInterpolator.interpolate(dArray2, dArray3[i]);
        }
        double[][] dArray5 = new double[n2][n3];
        for (int i = 0; i < n3; ++i) {
            UnivariateFunction univariateFunction = polynomialSplineFunctionArray[i].derivative();
            for (int j = 0; j < n2; ++j) {
                dArray5[j][i] = univariateFunction.value(dArray[j]);
            }
        }
        double[][] dArray6 = new double[n2][n3];
        for (int i = 0; i < n2; ++i) {
            UnivariateFunction univariateFunction = polynomialSplineFunctionArray2[i].derivative();
            for (n = 0; n < n3; ++n) {
                dArray6[i][n] = univariateFunction.value(dArray2[n]);
            }
        }
        double[][] dArray7 = new double[n2][n3];
        for (int i = 0; i < n2; ++i) {
            n = this.nextIndex(i, n2);
            int n4 = this.previousIndex(i);
            for (int j = 0; j < n3; ++j) {
                int n5 = this.nextIndex(j, n3);
                int n6 = this.previousIndex(j);
                dArray7[i][j] = (dArray3[n][n5] - dArray3[n][n6] - dArray3[n4][n5] + dArray3[n4][n6]) / ((dArray[n] - dArray[n4]) * (dArray2[n5] - dArray2[n6]));
            }
        }
        return new BicubicSplineInterpolatingFunction(dArray, dArray2, dArray3, dArray5, dArray6, dArray7, this.initializeDerivatives);
    }

    private int nextIndex(int n, int n2) {
        int n3 = n + 1;
        return n3 < n2 ? n3 : n3 - 1;
    }

    private int previousIndex(int n) {
        int n2 = n - 1;
        return n2 >= 0 ? n2 : 0;
    }
}

