/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import java.io.Serializable;
import org.apache.commons.math3.analysis.interpolation.UnivariateInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunctionLagrangeForm;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunctionNewtonForm;

public class DividedDifferenceInterpolator
implements UnivariateInterpolator,
Serializable {
    private static final long serialVersionUID = 107049519551235069L;

    public PolynomialFunctionNewtonForm interpolate(double[] dArray, double[] dArray2) {
        PolynomialFunctionLagrangeForm.verifyInterpolationArray(dArray, dArray2, true);
        double[] dArray3 = new double[dArray.length - 1];
        System.arraycopy(dArray, 0, dArray3, 0, dArray3.length);
        double[] dArray4 = DividedDifferenceInterpolator.computeDividedDifference(dArray, dArray2);
        return new PolynomialFunctionNewtonForm(dArray4, dArray3);
    }

    protected static double[] computeDividedDifference(double[] dArray, double[] dArray2) {
        PolynomialFunctionLagrangeForm.verifyInterpolationArray(dArray, dArray2, true);
        double[] dArray3 = (double[])dArray2.clone();
        int n = dArray.length;
        double[] dArray4 = new double[n];
        dArray4[0] = dArray3[0];
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < n - i; ++j) {
                double d = dArray[j + i] - dArray[j];
                dArray3[j] = (dArray3[j + 1] - dArray3[j]) / d;
            }
            dArray4[i] = dArray3[0];
        }
        return dArray4;
    }
}

