/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableVectorFunction;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.CombinatoricsUtils;

public class HermiteInterpolator
implements UnivariateDifferentiableVectorFunction {
    private final List<Double> abscissae = new ArrayList<Double>();
    private final List<double[]> topDiagonal = new ArrayList<double[]>();
    private final List<double[]> bottomDiagonal = new ArrayList<double[]>();

    public void addSamplePoint(double d, double[] ... dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            int n;
            double[] dArray2 = (double[])dArray[i].clone();
            if (i > 1) {
                double d2 = 1.0 / (double)CombinatoricsUtils.factorial(i);
                n = 0;
                while (n < dArray2.length) {
                    int n2 = n++;
                    dArray2[n2] = dArray2[n2] * d2;
                }
            }
            int n3 = this.abscissae.size();
            this.bottomDiagonal.add(n3 - i, dArray2);
            double[] dArray3 = dArray2;
            for (n = i; n < n3; ++n) {
                double[] dArray4 = this.bottomDiagonal.get(n3 - (n + 1));
                double d3 = 1.0 / (d - this.abscissae.get(n3 - (n + 1)));
                if (Double.isInfinite(d3)) {
                    throw new ZeroException((Localizable)LocalizedFormats.DUPLICATED_ABSCISSA_DIVISION_BY_ZERO, d);
                }
                for (int j = 0; j < dArray2.length; ++j) {
                    dArray4[j] = d3 * (dArray3[j] - dArray4[j]);
                }
                dArray3 = dArray4;
            }
            this.topDiagonal.add((double[])dArray3.clone());
            this.abscissae.add(d);
        }
    }

    public PolynomialFunction[] getPolynomials() {
        this.checkInterpolation();
        PolynomialFunction polynomialFunction = this.polynomial(0.0);
        PolynomialFunction[] polynomialFunctionArray = new PolynomialFunction[this.topDiagonal.get(0).length];
        for (int i = 0; i < polynomialFunctionArray.length; ++i) {
            polynomialFunctionArray[i] = polynomialFunction;
        }
        PolynomialFunction polynomialFunction2 = this.polynomial(1.0);
        for (int i = 0; i < this.topDiagonal.size(); ++i) {
            double[] dArray = this.topDiagonal.get(i);
            for (int j = 0; j < polynomialFunctionArray.length; ++j) {
                polynomialFunctionArray[j] = polynomialFunctionArray[j].add(polynomialFunction2.multiply(this.polynomial(dArray[j])));
            }
            polynomialFunction2 = polynomialFunction2.multiply(this.polynomial(-this.abscissae.get(i).doubleValue(), 1.0));
        }
        return polynomialFunctionArray;
    }

    public double[] value(double d) {
        this.checkInterpolation();
        double[] dArray = new double[this.topDiagonal.get(0).length];
        double d2 = 1.0;
        for (int i = 0; i < this.topDiagonal.size(); ++i) {
            double[] dArray2 = this.topDiagonal.get(i);
            for (int j = 0; j < dArray.length; ++j) {
                int n = j;
                dArray[n] = dArray[n] + dArray2[j] * d2;
            }
            double d3 = d - this.abscissae.get(i);
            d2 *= d3;
        }
        return dArray;
    }

    public DerivativeStructure[] value(DerivativeStructure derivativeStructure) {
        this.checkInterpolation();
        Object[] objectArray = new DerivativeStructure[this.topDiagonal.get(0).length];
        Arrays.fill(objectArray, derivativeStructure.getField().getZero());
        DerivativeStructure derivativeStructure2 = derivativeStructure.getField().getOne();
        for (int i = 0; i < this.topDiagonal.size(); ++i) {
            double[] dArray = this.topDiagonal.get(i);
            for (int j = 0; j < objectArray.length; ++j) {
                objectArray[j] = ((DerivativeStructure)objectArray[j]).add(derivativeStructure2.multiply(dArray[j]));
            }
            DerivativeStructure derivativeStructure3 = derivativeStructure.subtract(this.abscissae.get(i));
            derivativeStructure2 = derivativeStructure2.multiply(derivativeStructure3);
        }
        return objectArray;
    }

    private void checkInterpolation() {
        if (this.abscissae.isEmpty()) {
            throw new NoDataException(LocalizedFormats.EMPTY_INTERPOLATION_SAMPLE);
        }
    }

    private PolynomialFunction polynomial(double ... dArray) {
        return new PolynomialFunction(dArray);
    }
}

