/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.interpolation.InterpolatingMicrosphere;
import org.apache.commons.math3.util.FastMath;

public class InterpolatingMicrosphere2D
extends InterpolatingMicrosphere {
    private static final int DIMENSION = 2;

    public InterpolatingMicrosphere2D(int n, double d, double d2, double d3) {
        super(2, n, d, d2, d3);
        for (int i = 0; i < n; ++i) {
            double d4 = (double)i * (Math.PI * 2) / (double)n;
            this.add(new double[]{FastMath.cos(d4), FastMath.sin(d4)}, false);
        }
    }

    protected InterpolatingMicrosphere2D(InterpolatingMicrosphere2D interpolatingMicrosphere2D) {
        super(interpolatingMicrosphere2D);
    }

    public InterpolatingMicrosphere2D copy() {
        return new InterpolatingMicrosphere2D(this);
    }
}

