/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.interpolation.BicubicSplineInterpolatingFunction;
import org.apache.commons.math3.analysis.interpolation.BicubicSplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.fitting.PolynomialFitter;
import org.apache.commons.math3.optim.SimpleVectorValueChecker;
import org.apache.commons.math3.optim.nonlinear.vector.jacobian.GaussNewtonOptimizer;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.Precision;

@Deprecated
public class SmoothingPolynomialBicubicSplineInterpolator
extends BicubicSplineInterpolator {
    private final PolynomialFitter xFitter;
    private final int xDegree;
    private final PolynomialFitter yFitter;
    private final int yDegree;

    public SmoothingPolynomialBicubicSplineInterpolator() {
        this(3);
    }

    public SmoothingPolynomialBicubicSplineInterpolator(int n) {
        this(n, n);
    }

    public SmoothingPolynomialBicubicSplineInterpolator(int n, int n2) {
        if (n < 0) {
            throw new NotPositiveException(n);
        }
        if (n2 < 0) {
            throw new NotPositiveException(n2);
        }
        this.xDegree = n;
        this.yDegree = n2;
        double d = 100.0;
        SimpleVectorValueChecker simpleVectorValueChecker = new SimpleVectorValueChecker(100.0 * Precision.EPSILON, 100.0 * Precision.SAFE_MIN);
        this.xFitter = new PolynomialFitter(new GaussNewtonOptimizer(false, simpleVectorValueChecker));
        this.yFitter = new PolynomialFitter(new GaussNewtonOptimizer(false, simpleVectorValueChecker));
    }

    public BicubicSplineInterpolatingFunction interpolate(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n;
        int n2;
        if (dArray.length == 0 || dArray2.length == 0 || dArray3.length == 0) {
            throw new NoDataException();
        }
        if (dArray.length != dArray3.length) {
            throw new DimensionMismatchException(dArray.length, dArray3.length);
        }
        int n3 = dArray.length;
        int n4 = dArray2.length;
        for (int i = 0; i < n3; ++i) {
            if (dArray3[i].length == n4) continue;
            throw new DimensionMismatchException(dArray3[i].length, n4);
        }
        MathArrays.checkOrder(dArray);
        MathArrays.checkOrder(dArray2);
        PolynomialFunction[] polynomialFunctionArray = new PolynomialFunction[n4];
        for (int i = 0; i < n4; ++i) {
            this.xFitter.clearObservations();
            for (n2 = 0; n2 < n3; ++n2) {
                this.xFitter.addObservedPoint(1.0, dArray[n2], dArray3[n2][i]);
            }
            polynomialFunctionArray[i] = new PolynomialFunction(this.xFitter.fit(new double[this.xDegree + 1]));
        }
        double[][] dArray4 = new double[n3][n4];
        for (n2 = 0; n2 < n4; ++n2) {
            PolynomialFunction polynomialFunction = polynomialFunctionArray[n2];
            for (n = 0; n < n3; ++n) {
                dArray4[n][n2] = polynomialFunction.value(dArray[n]);
            }
        }
        PolynomialFunction[] polynomialFunctionArray2 = new PolynomialFunction[n3];
        for (int i = 0; i < n3; ++i) {
            this.yFitter.clearObservations();
            for (n = 0; n < n4; ++n) {
                this.yFitter.addObservedPoint(1.0, dArray2[n], dArray4[i][n]);
            }
            polynomialFunctionArray2[i] = new PolynomialFunction(this.yFitter.fit(new double[this.yDegree + 1]));
        }
        double[][] dArray5 = new double[n3][n4];
        for (n = 0; n < n3; ++n) {
            PolynomialFunction polynomialFunction = polynomialFunctionArray2[n];
            for (int i = 0; i < n4; ++i) {
                dArray5[n][i] = polynomialFunction.value(dArray2[i]);
            }
        }
        return super.interpolate(dArray, dArray2, dArray5);
    }
}

