/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.interpolation.UnivariateInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.MathArrays;

public class SplineInterpolator
implements UnivariateInterpolator {
    public PolynomialSplineFunction interpolate(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        if (dArray.length < 3) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NUMBER_OF_POINTS, (Number)dArray.length, 3, true);
        }
        int n = dArray.length - 1;
        MathArrays.checkOrder(dArray);
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray3[i] = dArray[i + 1] - dArray[i];
        }
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n + 1];
        dArray4[0] = 0.0;
        dArray5[0] = 0.0;
        double d = 0.0;
        for (int i = 1; i < n; ++i) {
            d = 2.0 * (dArray[i + 1] - dArray[i - 1]) - dArray3[i - 1] * dArray4[i - 1];
            dArray4[i] = dArray3[i] / d;
            dArray5[i] = (3.0 * (dArray2[i + 1] * dArray3[i - 1] - dArray2[i] * (dArray[i + 1] - dArray[i - 1]) + dArray2[i - 1] * dArray3[i]) / (dArray3[i - 1] * dArray3[i]) - dArray3[i - 1] * dArray5[i - 1]) / d;
        }
        double[] dArray6 = new double[n];
        double[] dArray7 = new double[n + 1];
        double[] dArray8 = new double[n];
        dArray5[n] = 0.0;
        dArray7[n] = 0.0;
        for (int i = n - 1; i >= 0; --i) {
            dArray7[i] = dArray5[i] - dArray4[i] * dArray7[i + 1];
            dArray6[i] = (dArray2[i + 1] - dArray2[i]) / dArray3[i] - dArray3[i] * (dArray7[i + 1] + 2.0 * dArray7[i]) / 3.0;
            dArray8[i] = (dArray7[i + 1] - dArray7[i]) / (3.0 * dArray3[i]);
        }
        PolynomialFunction[] polynomialFunctionArray = new PolynomialFunction[n];
        double[] dArray9 = new double[4];
        for (int i = 0; i < n; ++i) {
            dArray9[0] = dArray2[i];
            dArray9[1] = dArray6[i];
            dArray9[2] = dArray7[i];
            dArray9[3] = dArray8[i];
            polynomialFunctionArray[i] = new PolynomialFunction(dArray9);
        }
        return new PolynomialSplineFunction(dArray, polynomialFunctionArray);
    }
}

