/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.UnivariateInterpolator;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;

public class UnivariatePeriodicInterpolator
implements UnivariateInterpolator {
    public static final int DEFAULT_EXTEND = 5;
    private final UnivariateInterpolator interpolator;
    private final double period;
    private final int extend;

    public UnivariatePeriodicInterpolator(UnivariateInterpolator univariateInterpolator, double d, int n) {
        this.interpolator = univariateInterpolator;
        this.period = d;
        this.extend = n;
    }

    public UnivariatePeriodicInterpolator(UnivariateInterpolator univariateInterpolator, double d) {
        this(univariateInterpolator, d, 5);
    }

    public UnivariateFunction interpolate(double[] dArray, double[] dArray2) {
        int n;
        int n2;
        if (dArray.length < this.extend) {
            throw new NumberIsTooSmallException(dArray.length, (Number)this.extend, true);
        }
        MathArrays.checkOrder(dArray);
        final double d = dArray[0];
        int n3 = dArray.length + this.extend * 2;
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            n = n2 + this.extend;
            dArray3[n] = MathUtils.reduce(dArray[n2], this.period, d);
            dArray4[n] = dArray2[n2];
        }
        for (n2 = 0; n2 < this.extend; ++n2) {
            n = dArray.length - this.extend + n2;
            dArray3[n2] = MathUtils.reduce(dArray[n], this.period, d) - this.period;
            dArray4[n2] = dArray2[n];
            n = n3 - this.extend + n2;
            dArray3[n] = MathUtils.reduce(dArray[n2], this.period, d) + this.period;
            dArray4[n] = dArray2[n2];
        }
        MathArrays.sortInPlace(dArray3, new double[][]{dArray4});
        final UnivariateFunction univariateFunction = this.interpolator.interpolate(dArray3, dArray4);
        return new UnivariateFunction(){

            public double value(double d2) {
                return univariateFunction.value(MathUtils.reduce(d2, UnivariatePeriodicInterpolator.this.period, d));
            }
        };
    }
}

