/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.polynomials;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

public class PolynomialFunctionLagrangeForm
implements UnivariateFunction {
    private double[] coefficients;
    private final double[] x;
    private final double[] y;
    private boolean coefficientsComputed;

    public PolynomialFunctionLagrangeForm(double[] dArray, double[] dArray2) {
        this.x = new double[dArray.length];
        this.y = new double[dArray2.length];
        System.arraycopy(dArray, 0, this.x, 0, dArray.length);
        System.arraycopy(dArray2, 0, this.y, 0, dArray2.length);
        this.coefficientsComputed = false;
        if (!PolynomialFunctionLagrangeForm.verifyInterpolationArray(dArray, dArray2, false)) {
            MathArrays.sortInPlace(this.x, new double[][]{this.y});
            PolynomialFunctionLagrangeForm.verifyInterpolationArray(this.x, this.y, true);
        }
    }

    public double value(double d) {
        return PolynomialFunctionLagrangeForm.evaluateInternal(this.x, this.y, d);
    }

    public int degree() {
        return this.x.length - 1;
    }

    public double[] getInterpolatingPoints() {
        double[] dArray = new double[this.x.length];
        System.arraycopy(this.x, 0, dArray, 0, this.x.length);
        return dArray;
    }

    public double[] getInterpolatingValues() {
        double[] dArray = new double[this.y.length];
        System.arraycopy(this.y, 0, dArray, 0, this.y.length);
        return dArray;
    }

    public double[] getCoefficients() {
        if (!this.coefficientsComputed) {
            this.computeCoefficients();
        }
        double[] dArray = new double[this.coefficients.length];
        System.arraycopy(this.coefficients, 0, dArray, 0, this.coefficients.length);
        return dArray;
    }

    public static double evaluate(double[] dArray, double[] dArray2, double d) {
        if (PolynomialFunctionLagrangeForm.verifyInterpolationArray(dArray, dArray2, false)) {
            return PolynomialFunctionLagrangeForm.evaluateInternal(dArray, dArray2, d);
        }
        double[] dArray3 = new double[dArray.length];
        double[] dArray4 = new double[dArray2.length];
        System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
        System.arraycopy(dArray2, 0, dArray4, 0, dArray2.length);
        MathArrays.sortInPlace(dArray3, new double[][]{dArray4});
        PolynomialFunctionLagrangeForm.verifyInterpolationArray(dArray3, dArray4, true);
        return PolynomialFunctionLagrangeForm.evaluateInternal(dArray3, dArray4, d);
    }

    private static double evaluateInternal(double[] dArray, double[] dArray2, double d) {
        int n = 0;
        int n2 = dArray.length;
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        double d2 = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n2; ++i) {
            dArray3[i] = dArray2[i];
            dArray4[i] = dArray2[i];
            double d3 = FastMath.abs(d - dArray[i]);
            if (!(d3 < d2)) continue;
            n = i;
            d2 = d3;
        }
        double d4 = dArray2[n];
        for (int i = 1; i < n2; ++i) {
            for (int j = 0; j < n2 - i; ++j) {
                double d5 = dArray[j] - d;
                double d6 = dArray[i + j] - d;
                double d7 = dArray[j] - dArray[i + j];
                double d8 = (dArray3[j + 1] - dArray4[j]) / d7;
                dArray3[j] = d5 * d8;
                dArray4[j] = d6 * d8;
            }
            if ((double)n < 0.5 * (double)(n2 - i + 1)) {
                d4 += dArray3[n];
                continue;
            }
            d4 += dArray4[--n];
        }
        return d4;
    }

    protected void computeCoefficients() {
        int n;
        int n2 = this.degree() + 1;
        this.coefficients = new double[n2];
        for (int i = 0; i < n2; ++i) {
            this.coefficients[i] = 0.0;
        }
        double[] dArray = new double[n2 + 1];
        dArray[0] = 1.0;
        for (int i = 0; i < n2; ++i) {
            for (n = i; n > 0; --n) {
                dArray[n] = dArray[n - 1] - dArray[n] * this.x[i];
            }
            dArray[0] = dArray[0] * -this.x[i];
            dArray[i + 1] = 1.0;
        }
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            double d = 1.0;
            for (int i = 0; i < n2; ++i) {
                if (n == i) continue;
                d *= this.x[n] - this.x[i];
            }
            double d2 = this.y[n] / d;
            dArray2[n2 - 1] = dArray[n2];
            int n3 = n2 - 1;
            this.coefficients[n3] = this.coefficients[n3] + d2 * dArray2[n2 - 1];
            for (int i = n2 - 2; i >= 0; --i) {
                dArray2[i] = dArray[i + 1] + dArray2[i + 1] * this.x[n];
                int n4 = i;
                this.coefficients[n4] = this.coefficients[n4] + d2 * dArray2[i];
            }
        }
        this.coefficientsComputed = true;
    }

    public static boolean verifyInterpolationArray(double[] dArray, double[] dArray2, boolean bl) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        if (dArray.length < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.WRONG_NUMBER_OF_POINTS, (Number)2, dArray.length, true);
        }
        return MathArrays.checkOrder(dArray, MathArrays.OrderDirection.INCREASING, true, bl);
    }
}

