/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.complex;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.MathParseException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.CompositeFormat;

public class ComplexFormat {
    private static final String DEFAULT_IMAGINARY_CHARACTER = "i";
    private final String imaginaryCharacter;
    private final NumberFormat imaginaryFormat;
    private final NumberFormat realFormat;

    public ComplexFormat() {
        this.imaginaryCharacter = DEFAULT_IMAGINARY_CHARACTER;
        this.realFormat = this.imaginaryFormat = CompositeFormat.getDefaultNumberFormat();
    }

    public ComplexFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new NullArgumentException(LocalizedFormats.IMAGINARY_FORMAT, new Object[0]);
        }
        this.imaginaryCharacter = DEFAULT_IMAGINARY_CHARACTER;
        this.imaginaryFormat = numberFormat;
        this.realFormat = numberFormat;
    }

    public ComplexFormat(NumberFormat numberFormat, NumberFormat numberFormat2) {
        if (numberFormat2 == null) {
            throw new NullArgumentException(LocalizedFormats.IMAGINARY_FORMAT, new Object[0]);
        }
        if (numberFormat == null) {
            throw new NullArgumentException(LocalizedFormats.REAL_FORMAT, new Object[0]);
        }
        this.imaginaryCharacter = DEFAULT_IMAGINARY_CHARACTER;
        this.imaginaryFormat = numberFormat2;
        this.realFormat = numberFormat;
    }

    public ComplexFormat(String string) {
        this(string, CompositeFormat.getDefaultNumberFormat());
    }

    public ComplexFormat(String string, NumberFormat numberFormat) {
        this(string, numberFormat, numberFormat);
    }

    public ComplexFormat(String string, NumberFormat numberFormat, NumberFormat numberFormat2) {
        if (string == null) {
            throw new NullArgumentException();
        }
        if (string.length() == 0) {
            throw new NoDataException();
        }
        if (numberFormat2 == null) {
            throw new NullArgumentException(LocalizedFormats.IMAGINARY_FORMAT, new Object[0]);
        }
        if (numberFormat == null) {
            throw new NullArgumentException(LocalizedFormats.REAL_FORMAT, new Object[0]);
        }
        this.imaginaryCharacter = string;
        this.imaginaryFormat = numberFormat2;
        this.realFormat = numberFormat;
    }

    public static Locale[] getAvailableLocales() {
        return NumberFormat.getAvailableLocales();
    }

    public String format(Complex complex) {
        return this.format(complex, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Double d) {
        return this.format(new Complex(d, 0.0), new StringBuffer(), new FieldPosition(0)).toString();
    }

    public StringBuffer format(Complex complex, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        double d = complex.getReal();
        CompositeFormat.formatDouble(d, this.getRealFormat(), stringBuffer, fieldPosition);
        double d2 = complex.getImaginary();
        if (d2 < 0.0) {
            stringBuffer.append(" - ");
            StringBuffer stringBuffer2 = this.formatImaginary(-d2, new StringBuffer(), fieldPosition);
            stringBuffer.append(stringBuffer2);
            stringBuffer.append(this.getImaginaryCharacter());
        } else if (d2 > 0.0 || Double.isNaN(d2)) {
            stringBuffer.append(" + ");
            StringBuffer stringBuffer3 = this.formatImaginary(d2, new StringBuffer(), fieldPosition);
            stringBuffer.append(stringBuffer3);
            stringBuffer.append(this.getImaginaryCharacter());
        }
        return stringBuffer;
    }

    private StringBuffer formatImaginary(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        CompositeFormat.formatDouble(d, this.getImaginaryFormat(), stringBuffer, fieldPosition);
        if (stringBuffer.toString().equals("1")) {
            stringBuffer.setLength(0);
        }
        return stringBuffer;
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        StringBuffer stringBuffer2 = null;
        if (object instanceof Complex) {
            stringBuffer2 = this.format((Complex)object, stringBuffer, fieldPosition);
        } else if (object instanceof Number) {
            stringBuffer2 = this.format(new Complex(((Number)object).doubleValue(), 0.0), stringBuffer, fieldPosition);
        } else {
            throw new MathIllegalArgumentException(LocalizedFormats.CANNOT_FORMAT_INSTANCE_AS_COMPLEX, object.getClass().getName());
        }
        return stringBuffer2;
    }

    public String getImaginaryCharacter() {
        return this.imaginaryCharacter;
    }

    public NumberFormat getImaginaryFormat() {
        return this.imaginaryFormat;
    }

    public static ComplexFormat getInstance() {
        return ComplexFormat.getInstance(Locale.getDefault());
    }

    public static ComplexFormat getInstance(Locale locale) {
        NumberFormat numberFormat = CompositeFormat.getDefaultNumberFormat(locale);
        return new ComplexFormat(numberFormat);
    }

    public static ComplexFormat getInstance(String string, Locale locale) {
        NumberFormat numberFormat = CompositeFormat.getDefaultNumberFormat(locale);
        return new ComplexFormat(string, numberFormat);
    }

    public NumberFormat getRealFormat() {
        return this.realFormat;
    }

    public Complex parse(String string) {
        ParsePosition parsePosition = new ParsePosition(0);
        Complex complex = this.parse(string, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new MathParseException(string, parsePosition.getErrorIndex(), Complex.class);
        }
        return complex;
    }

    public Complex parse(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        CompositeFormat.parseAndIgnoreWhitespace(string, parsePosition);
        Number number = CompositeFormat.parseNumber(string, this.getRealFormat(), parsePosition);
        if (number == null) {
            parsePosition.setIndex(n);
            return null;
        }
        int n2 = parsePosition.getIndex();
        char c = CompositeFormat.parseNextCharacter(string, parsePosition);
        int n3 = 0;
        switch (c) {
            case '\u0000': {
                return new Complex(number.doubleValue(), 0.0);
            }
            case '-': {
                n3 = -1;
                break;
            }
            case '+': {
                n3 = 1;
                break;
            }
            default: {
                parsePosition.setIndex(n);
                parsePosition.setErrorIndex(n2);
                return null;
            }
        }
        CompositeFormat.parseAndIgnoreWhitespace(string, parsePosition);
        Number number2 = CompositeFormat.parseNumber(string, this.getRealFormat(), parsePosition);
        if (number2 == null) {
            parsePosition.setIndex(n);
            return null;
        }
        if (!CompositeFormat.parseFixedstring(string, this.getImaginaryCharacter(), parsePosition)) {
            return null;
        }
        return new Complex(number.doubleValue(), number2.doubleValue() * (double)n3);
    }
}

