/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.complex;

import java.io.Serializable;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;
import org.apache.commons.math3.util.Precision;

public final class Quaternion
implements Serializable {
    public static final Quaternion IDENTITY = new Quaternion(1.0, 0.0, 0.0, 0.0);
    public static final Quaternion ZERO = new Quaternion(0.0, 0.0, 0.0, 0.0);
    public static final Quaternion I = new Quaternion(0.0, 1.0, 0.0, 0.0);
    public static final Quaternion J = new Quaternion(0.0, 0.0, 1.0, 0.0);
    public static final Quaternion K = new Quaternion(0.0, 0.0, 0.0, 1.0);
    private static final long serialVersionUID = 20092012L;
    private final double q0;
    private final double q1;
    private final double q2;
    private final double q3;

    public Quaternion(double d, double d2, double d3, double d4) {
        this.q0 = d;
        this.q1 = d2;
        this.q2 = d3;
        this.q3 = d4;
    }

    public Quaternion(double d, double[] dArray) {
        if (dArray.length != 3) {
            throw new DimensionMismatchException(dArray.length, 3);
        }
        this.q0 = d;
        this.q1 = dArray[0];
        this.q2 = dArray[1];
        this.q3 = dArray[2];
    }

    public Quaternion(double[] dArray) {
        this(0.0, dArray);
    }

    public Quaternion getConjugate() {
        return new Quaternion(this.q0, -this.q1, -this.q2, -this.q3);
    }

    public static Quaternion multiply(Quaternion quaternion, Quaternion quaternion2) {
        double d = quaternion.getQ0();
        double d2 = quaternion.getQ1();
        double d3 = quaternion.getQ2();
        double d4 = quaternion.getQ3();
        double d5 = quaternion2.getQ0();
        double d6 = quaternion2.getQ1();
        double d7 = quaternion2.getQ2();
        double d8 = quaternion2.getQ3();
        double d9 = d * d5 - d2 * d6 - d3 * d7 - d4 * d8;
        double d10 = d * d6 + d2 * d5 + d3 * d8 - d4 * d7;
        double d11 = d * d7 - d2 * d8 + d3 * d5 + d4 * d6;
        double d12 = d * d8 + d2 * d7 - d3 * d6 + d4 * d5;
        return new Quaternion(d9, d10, d11, d12);
    }

    public Quaternion multiply(Quaternion quaternion) {
        return Quaternion.multiply(this, quaternion);
    }

    public static Quaternion add(Quaternion quaternion, Quaternion quaternion2) {
        return new Quaternion(quaternion.getQ0() + quaternion2.getQ0(), quaternion.getQ1() + quaternion2.getQ1(), quaternion.getQ2() + quaternion2.getQ2(), quaternion.getQ3() + quaternion2.getQ3());
    }

    public Quaternion add(Quaternion quaternion) {
        return Quaternion.add(this, quaternion);
    }

    public static Quaternion subtract(Quaternion quaternion, Quaternion quaternion2) {
        return new Quaternion(quaternion.getQ0() - quaternion2.getQ0(), quaternion.getQ1() - quaternion2.getQ1(), quaternion.getQ2() - quaternion2.getQ2(), quaternion.getQ3() - quaternion2.getQ3());
    }

    public Quaternion subtract(Quaternion quaternion) {
        return Quaternion.subtract(this, quaternion);
    }

    public static double dotProduct(Quaternion quaternion, Quaternion quaternion2) {
        return quaternion.getQ0() * quaternion2.getQ0() + quaternion.getQ1() * quaternion2.getQ1() + quaternion.getQ2() * quaternion2.getQ2() + quaternion.getQ3() * quaternion2.getQ3();
    }

    public double dotProduct(Quaternion quaternion) {
        return Quaternion.dotProduct(this, quaternion);
    }

    public double getNorm() {
        return FastMath.sqrt(this.q0 * this.q0 + this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3);
    }

    public Quaternion normalize() {
        double d = this.getNorm();
        if (d < Precision.SAFE_MIN) {
            throw new ZeroException((Localizable)LocalizedFormats.NORM, d);
        }
        return new Quaternion(this.q0 / d, this.q1 / d, this.q2 / d, this.q3 / d);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Quaternion) {
            Quaternion quaternion = (Quaternion)object;
            return this.q0 == quaternion.getQ0() && this.q1 == quaternion.getQ1() && this.q2 == quaternion.getQ2() && this.q3 == quaternion.getQ3();
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        for (double d : new double[]{this.q0, this.q1, this.q2, this.q3}) {
            int n2 = MathUtils.hash(d);
            n = 31 * n + n2;
        }
        return n;
    }

    public boolean equals(Quaternion quaternion, double d) {
        return Precision.equals(this.q0, quaternion.getQ0(), d) && Precision.equals(this.q1, quaternion.getQ1(), d) && Precision.equals(this.q2, quaternion.getQ2(), d) && Precision.equals(this.q3, quaternion.getQ3(), d);
    }

    public boolean isUnitQuaternion(double d) {
        return Precision.equals(this.getNorm(), 1.0, d);
    }

    public boolean isPureQuaternion(double d) {
        return FastMath.abs(this.getQ0()) <= d;
    }

    public Quaternion getPositivePolarForm() {
        if (this.getQ0() < 0.0) {
            Quaternion quaternion = this.normalize();
            return new Quaternion(-quaternion.getQ0(), -quaternion.getQ1(), -quaternion.getQ2(), -quaternion.getQ3());
        }
        return this.normalize();
    }

    public Quaternion getInverse() {
        double d = this.q0 * this.q0 + this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3;
        if (d < Precision.SAFE_MIN) {
            throw new ZeroException((Localizable)LocalizedFormats.NORM, d);
        }
        return new Quaternion(this.q0 / d, -this.q1 / d, -this.q2 / d, -this.q3 / d);
    }

    public double getQ0() {
        return this.q0;
    }

    public double getQ1() {
        return this.q1;
    }

    public double getQ2() {
        return this.q2;
    }

    public double getQ3() {
        return this.q3;
    }

    public double getScalarPart() {
        return this.getQ0();
    }

    public double[] getVectorPart() {
        return new double[]{this.getQ1(), this.getQ2(), this.getQ3()};
    }

    public Quaternion multiply(double d) {
        return new Quaternion(d * this.q0, d * this.q1, d * this.q2, d * this.q3);
    }

    public String toString() {
        String string = " ";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(this.q0).append(" ").append(this.q1).append(" ").append(this.q2).append(" ").append(this.q3).append("]");
        return stringBuilder.toString();
    }
}

