/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.complex;

import java.io.Serializable;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;

public class RootsOfUnity
implements Serializable {
    private static final long serialVersionUID = 20120201L;
    private int omegaCount = 0;
    private double[] omegaReal = null;
    private double[] omegaImaginaryCounterClockwise = null;
    private double[] omegaImaginaryClockwise = null;
    private boolean isCounterClockWise = true;

    public synchronized boolean isCounterClockWise() {
        if (this.omegaCount == 0) {
            throw new MathIllegalStateException(LocalizedFormats.ROOTS_OF_UNITY_NOT_COMPUTED_YET, new Object[0]);
        }
        return this.isCounterClockWise;
    }

    public synchronized void computeRoots(int n) {
        if (n == 0) {
            throw new ZeroException((Localizable)LocalizedFormats.CANNOT_COMPUTE_0TH_ROOT_OF_UNITY, new Object[0]);
        }
        this.isCounterClockWise = n > 0;
        int n2 = FastMath.abs(n);
        if (n2 == this.omegaCount) {
            return;
        }
        double d = Math.PI * 2 / (double)n2;
        double d2 = FastMath.cos(d);
        double d3 = FastMath.sin(d);
        this.omegaReal = new double[n2];
        this.omegaImaginaryCounterClockwise = new double[n2];
        this.omegaImaginaryClockwise = new double[n2];
        this.omegaReal[0] = 1.0;
        this.omegaImaginaryCounterClockwise[0] = 0.0;
        this.omegaImaginaryClockwise[0] = 0.0;
        for (int i = 1; i < n2; ++i) {
            this.omegaReal[i] = this.omegaReal[i - 1] * d2 - this.omegaImaginaryCounterClockwise[i - 1] * d3;
            this.omegaImaginaryCounterClockwise[i] = this.omegaReal[i - 1] * d3 + this.omegaImaginaryCounterClockwise[i - 1] * d2;
            this.omegaImaginaryClockwise[i] = -this.omegaImaginaryCounterClockwise[i];
        }
        this.omegaCount = n2;
    }

    public synchronized double getReal(int n) {
        if (this.omegaCount == 0) {
            throw new MathIllegalStateException(LocalizedFormats.ROOTS_OF_UNITY_NOT_COMPUTED_YET, new Object[0]);
        }
        if (n < 0 || n >= this.omegaCount) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_RANGE_ROOT_OF_UNITY_INDEX, (Number)n, 0, this.omegaCount - 1);
        }
        return this.omegaReal[n];
    }

    public synchronized double getImaginary(int n) {
        if (this.omegaCount == 0) {
            throw new MathIllegalStateException(LocalizedFormats.ROOTS_OF_UNITY_NOT_COMPUTED_YET, new Object[0]);
        }
        if (n < 0 || n >= this.omegaCount) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_RANGE_ROOT_OF_UNITY_INDEX, (Number)n, 0, this.omegaCount - 1);
        }
        return this.isCounterClockWise ? this.omegaImaginaryCounterClockwise[n] : this.omegaImaginaryClockwise[n];
    }

    public synchronized int getNumberOfRoots() {
        return this.omegaCount;
    }
}

