/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.dfp;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.dfp.Dfp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfpField
implements Field<Dfp> {
    public static final int FLAG_INVALID = 1;
    public static final int FLAG_DIV_ZERO = 2;
    public static final int FLAG_OVERFLOW = 4;
    public static final int FLAG_UNDERFLOW = 8;
    public static final int FLAG_INEXACT = 16;
    private static String sqr2String;
    private static String sqr2ReciprocalString;
    private static String sqr3String;
    private static String sqr3ReciprocalString;
    private static String piString;
    private static String eString;
    private static String ln2String;
    private static String ln5String;
    private static String ln10String;
    private final int radixDigits;
    private final Dfp zero;
    private final Dfp one;
    private final Dfp two;
    private final Dfp sqr2;
    private final Dfp[] sqr2Split;
    private final Dfp sqr2Reciprocal;
    private final Dfp sqr3;
    private final Dfp sqr3Reciprocal;
    private final Dfp pi;
    private final Dfp[] piSplit;
    private final Dfp e;
    private final Dfp[] eSplit;
    private final Dfp ln2;
    private final Dfp[] ln2Split;
    private final Dfp ln5;
    private final Dfp[] ln5Split;
    private final Dfp ln10;
    private RoundingMode rMode;
    private int ieeeFlags;

    public DfpField(int n) {
        this(n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DfpField(int n, boolean bl) {
        this.radixDigits = n < 13 ? 4 : (n + 3) / 4;
        this.rMode = RoundingMode.ROUND_HALF_EVEN;
        this.ieeeFlags = 0;
        this.zero = new Dfp(this, 0);
        this.one = new Dfp(this, 1);
        this.two = new Dfp(this, 2);
        if (bl) {
            Class<DfpField> clazz = DfpField.class;
            synchronized (DfpField.class) {
                DfpField.computeStringConstants(n < 67 ? 200 : 3 * n);
                this.sqr2 = new Dfp(this, sqr2String);
                this.sqr2Split = this.split(sqr2String);
                this.sqr2Reciprocal = new Dfp(this, sqr2ReciprocalString);
                this.sqr3 = new Dfp(this, sqr3String);
                this.sqr3Reciprocal = new Dfp(this, sqr3ReciprocalString);
                this.pi = new Dfp(this, piString);
                this.piSplit = this.split(piString);
                this.e = new Dfp(this, eString);
                this.eSplit = this.split(eString);
                this.ln2 = new Dfp(this, ln2String);
                this.ln2Split = this.split(ln2String);
                this.ln5 = new Dfp(this, ln5String);
                this.ln5Split = this.split(ln5String);
                this.ln10 = new Dfp(this, ln10String);
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            this.sqr2 = null;
            this.sqr2Split = null;
            this.sqr2Reciprocal = null;
            this.sqr3 = null;
            this.sqr3Reciprocal = null;
            this.pi = null;
            this.piSplit = null;
            this.e = null;
            this.eSplit = null;
            this.ln2 = null;
            this.ln2Split = null;
            this.ln5 = null;
            this.ln5Split = null;
            this.ln10 = null;
        }
    }

    public int getRadixDigits() {
        return this.radixDigits;
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        this.rMode = roundingMode;
    }

    public RoundingMode getRoundingMode() {
        return this.rMode;
    }

    public int getIEEEFlags() {
        return this.ieeeFlags;
    }

    public void clearIEEEFlags() {
        this.ieeeFlags = 0;
    }

    public void setIEEEFlags(int n) {
        this.ieeeFlags = n & 0x1F;
    }

    public void setIEEEFlagsBits(int n) {
        this.ieeeFlags |= n & 0x1F;
    }

    public Dfp newDfp() {
        return new Dfp(this);
    }

    public Dfp newDfp(byte by) {
        return new Dfp(this, by);
    }

    public Dfp newDfp(int n) {
        return new Dfp(this, n);
    }

    public Dfp newDfp(long l) {
        return new Dfp(this, l);
    }

    public Dfp newDfp(double d) {
        return new Dfp(this, d);
    }

    public Dfp newDfp(Dfp dfp) {
        return new Dfp(dfp);
    }

    public Dfp newDfp(String string) {
        return new Dfp(this, string);
    }

    public Dfp newDfp(byte by, byte by2) {
        return new Dfp(this, by, by2);
    }

    @Override
    public Dfp getZero() {
        return this.zero;
    }

    @Override
    public Dfp getOne() {
        return this.one;
    }

    @Override
    public Class<? extends FieldElement<Dfp>> getRuntimeClass() {
        return Dfp.class;
    }

    public Dfp getTwo() {
        return this.two;
    }

    public Dfp getSqr2() {
        return this.sqr2;
    }

    public Dfp[] getSqr2Split() {
        return (Dfp[])this.sqr2Split.clone();
    }

    public Dfp getSqr2Reciprocal() {
        return this.sqr2Reciprocal;
    }

    public Dfp getSqr3() {
        return this.sqr3;
    }

    public Dfp getSqr3Reciprocal() {
        return this.sqr3Reciprocal;
    }

    public Dfp getPi() {
        return this.pi;
    }

    public Dfp[] getPiSplit() {
        return (Dfp[])this.piSplit.clone();
    }

    public Dfp getE() {
        return this.e;
    }

    public Dfp[] getESplit() {
        return (Dfp[])this.eSplit.clone();
    }

    public Dfp getLn2() {
        return this.ln2;
    }

    public Dfp[] getLn2Split() {
        return (Dfp[])this.ln2Split.clone();
    }

    public Dfp getLn5() {
        return this.ln5;
    }

    public Dfp[] getLn5Split() {
        return (Dfp[])this.ln5Split.clone();
    }

    public Dfp getLn10() {
        return this.ln10;
    }

    private Dfp[] split(String string) {
        int n;
        Dfp[] dfpArray = new Dfp[2];
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        char[] cArray = new char[string.length()];
        for (n = 0; n < cArray.length; ++n) {
            cArray[n] = string.charAt(n);
            if (cArray[n] >= '1' && cArray[n] <= '9') {
                bl = false;
            }
            if (cArray[n] == '.') {
                n3 += (400 - n3) % 4;
                bl = false;
            }
            if (n3 == this.radixDigits / 2 * 4) {
                n2 = n;
                break;
            }
            if (cArray[n] < '0' || cArray[n] > '9' || bl) continue;
            ++n3;
        }
        dfpArray[0] = new Dfp(this, new String(cArray, 0, n2));
        for (n = 0; n < cArray.length; ++n) {
            cArray[n] = string.charAt(n);
            if (cArray[n] < '0' || cArray[n] > '9' || n >= n2) continue;
            cArray[n] = 48;
        }
        dfpArray[1] = new Dfp(this, new String(cArray));
        return dfpArray;
    }

    private static void computeStringConstants(int n) {
        if (sqr2String == null || sqr2String.length() < n - 3) {
            DfpField dfpField = new DfpField(n, false);
            Dfp dfp = new Dfp(dfpField, 1);
            Dfp dfp2 = new Dfp(dfpField, 2);
            Dfp dfp3 = new Dfp(dfpField, 3);
            Dfp dfp4 = dfp2.sqrt();
            sqr2String = dfp4.toString();
            sqr2ReciprocalString = dfp.divide(dfp4).toString();
            Dfp dfp5 = dfp3.sqrt();
            sqr3String = dfp5.toString();
            sqr3ReciprocalString = dfp.divide(dfp5).toString();
            piString = DfpField.computePi(dfp, dfp2, dfp3).toString();
            eString = DfpField.computeExp(dfp, dfp).toString();
            ln2String = DfpField.computeLn(dfp2, dfp, dfp2).toString();
            ln5String = DfpField.computeLn(new Dfp(dfpField, 5), dfp, dfp2).toString();
            ln10String = DfpField.computeLn(new Dfp(dfpField, 10), dfp, dfp2).toString();
        }
    }

    private static Dfp computePi(Dfp dfp, Dfp dfp2, Dfp dfp3) {
        Dfp dfp4 = dfp2.sqrt();
        Dfp dfp5 = dfp4.subtract(dfp);
        Dfp dfp6 = dfp2.add(dfp2);
        Dfp dfp7 = dfp2;
        Dfp dfp8 = dfp2.multiply(dfp3.subtract(dfp2.multiply(dfp4)));
        for (int i = 1; i < 20; ++i) {
            Dfp dfp9 = dfp5;
            Dfp dfp10 = dfp5.multiply(dfp5);
            Dfp dfp11 = dfp.subtract(dfp10.multiply(dfp10));
            Dfp dfp12 = dfp11.sqrt().sqrt();
            dfp5 = dfp.subtract(dfp12).divide(dfp.add(dfp12));
            dfp7 = dfp7.multiply(dfp6);
            Dfp dfp13 = dfp.add(dfp5);
            Dfp dfp14 = dfp13.multiply(dfp13);
            dfp8 = dfp8.multiply(dfp14.multiply(dfp14)).subtract(dfp7.multiply(dfp5).multiply(dfp.add(dfp5).add(dfp5.multiply(dfp5))));
            if (dfp5.equals(dfp9)) break;
        }
        return dfp.divide(dfp8);
    }

    public static Dfp computeExp(Dfp dfp, Dfp dfp2) {
        Dfp dfp3 = new Dfp(dfp2);
        Dfp dfp4 = new Dfp(dfp2);
        Dfp dfp5 = new Dfp(dfp2);
        Dfp dfp6 = new Dfp(dfp2);
        Dfp dfp7 = new Dfp(dfp2);
        for (int i = 0; i < 10000; ++i) {
            dfp7 = dfp7.multiply(dfp);
            dfp3 = dfp3.add(dfp7.divide(dfp5));
            dfp6 = dfp6.add(dfp2);
            dfp5 = dfp5.multiply(dfp6);
            if (dfp3.equals(dfp4)) break;
            dfp4 = new Dfp(dfp3);
        }
        return dfp3;
    }

    public static Dfp computeLn(Dfp dfp, Dfp dfp2, Dfp dfp3) {
        int n = 1;
        Dfp dfp4 = dfp.add(new Dfp(dfp.getField(), -1)).divide(dfp.add(dfp2));
        Dfp dfp5 = new Dfp(dfp4);
        Dfp dfp6 = new Dfp(dfp4);
        Dfp dfp7 = new Dfp(dfp5);
        for (int i = 0; i < 10000; ++i) {
            dfp6 = dfp6.multiply(dfp4);
            Dfp dfp8 = (dfp6 = dfp6.multiply(dfp4)).divide(n += 2);
            if ((dfp5 = dfp5.add(dfp8)).equals(dfp7)) break;
            dfp7 = new Dfp(dfp5);
        }
        return dfp5.multiply(dfp3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RoundingMode {
        ROUND_DOWN,
        ROUND_UP,
        ROUND_HALF_UP,
        ROUND_HALF_DOWN,
        ROUND_HALF_EVEN,
        ROUND_HALF_ODD,
        ROUND_CEIL,
        ROUND_FLOOR;

    }
}

