/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.dfp;

import org.apache.commons.math3.dfp.Dfp;
import org.apache.commons.math3.dfp.DfpField;

public class DfpMath {
    private static final String POW_TRAP = "pow";

    private DfpMath() {
    }

    protected static Dfp[] split(DfpField dfpField, String string) {
        int n;
        Dfp[] dfpArray = new Dfp[2];
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        char[] cArray = new char[string.length()];
        for (n = 0; n < cArray.length; ++n) {
            cArray[n] = string.charAt(n);
            if (cArray[n] >= '1' && cArray[n] <= '9') {
                bl = false;
            }
            if (cArray[n] == '.') {
                n3 += (400 - n3) % 4;
                bl = false;
            }
            if (n3 == dfpField.getRadixDigits() / 2 * 4) {
                n2 = n;
                break;
            }
            if (cArray[n] < '0' || cArray[n] > '9' || bl) continue;
            ++n3;
        }
        dfpArray[0] = dfpField.newDfp(new String(cArray, 0, n2));
        for (n = 0; n < cArray.length; ++n) {
            cArray[n] = string.charAt(n);
            if (cArray[n] < '0' || cArray[n] > '9' || n >= n2) continue;
            cArray[n] = 48;
        }
        dfpArray[1] = dfpField.newDfp(new String(cArray));
        return dfpArray;
    }

    protected static Dfp[] split(Dfp dfp) {
        Dfp[] dfpArray = new Dfp[2];
        Dfp dfp2 = dfp.multiply(dfp.power10K(dfp.getRadixDigits() / 2));
        dfpArray[0] = dfp.add(dfp2).subtract(dfp2);
        dfpArray[1] = dfp.subtract(dfpArray[0]);
        return dfpArray;
    }

    protected static Dfp[] splitMult(Dfp[] dfpArray, Dfp[] dfpArray2) {
        Dfp[] dfpArray3 = new Dfp[2];
        dfpArray3[1] = dfpArray[0].getZero();
        dfpArray3[0] = dfpArray[0].multiply(dfpArray2[0]);
        if (dfpArray3[0].classify() == 1 || dfpArray3[0].equals(dfpArray3[1])) {
            return dfpArray3;
        }
        dfpArray3[1] = dfpArray[0].multiply(dfpArray2[1]).add(dfpArray[1].multiply(dfpArray2[0])).add(dfpArray[1].multiply(dfpArray2[1]));
        return dfpArray3;
    }

    protected static Dfp[] splitDiv(Dfp[] dfpArray, Dfp[] dfpArray2) {
        Dfp[] dfpArray3 = new Dfp[]{dfpArray[0].divide(dfpArray2[0]), dfpArray[1].multiply(dfpArray2[0]).subtract(dfpArray[0].multiply(dfpArray2[1]))};
        dfpArray3[1] = dfpArray3[1].divide(dfpArray2[0].multiply(dfpArray2[0]).add(dfpArray2[0].multiply(dfpArray2[1])));
        return dfpArray3;
    }

    protected static Dfp splitPow(Dfp[] dfpArray, int n) {
        int n2;
        boolean bl = false;
        Dfp[] dfpArray2 = new Dfp[2];
        Dfp[] dfpArray3 = new Dfp[]{dfpArray[0].getOne(), dfpArray[0].getZero()};
        if (n == 0) {
            return dfpArray3[0].add(dfpArray3[1]);
        }
        if (n < 0) {
            bl = true;
            n = -n;
        }
        do {
            int n3;
            dfpArray2[0] = new Dfp(dfpArray[0]);
            dfpArray2[1] = new Dfp(dfpArray[1]);
            n2 = 1;
            while (true) {
                n3 = n2;
                if ((n2 *= 2) > n) break;
                dfpArray2 = DfpMath.splitMult(dfpArray2, dfpArray2);
            }
            n2 = n3;
            dfpArray3 = DfpMath.splitMult(dfpArray3, dfpArray2);
        } while ((n -= n2) >= 1);
        dfpArray3[0] = dfpArray3[0].add(dfpArray3[1]);
        if (bl) {
            dfpArray3[0] = dfpArray[0].getOne().divide(dfpArray3[0]);
        }
        return dfpArray3[0];
    }

    public static Dfp pow(Dfp dfp, int n) {
        int n2;
        boolean bl = false;
        Dfp dfp2 = dfp.getOne();
        if (n == 0) {
            return dfp2;
        }
        if (n < 0) {
            bl = true;
            n = -n;
        }
        do {
            int n3;
            Dfp dfp3;
            Dfp dfp4 = new Dfp(dfp);
            n2 = 1;
            do {
                dfp3 = new Dfp(dfp4);
                n3 = n2;
                dfp4 = dfp4.multiply(dfp4);
            } while (n > (n2 *= 2));
            dfp4 = dfp3;
            n2 = n3;
            dfp2 = dfp2.multiply(dfp4);
        } while ((n -= n2) >= 1);
        if (bl) {
            dfp2 = dfp.getOne().divide(dfp2);
        }
        return dfp.newInstance(dfp2);
    }

    public static Dfp exp(Dfp dfp) {
        Dfp dfp2 = dfp.rint();
        Dfp dfp3 = dfp.subtract(dfp2);
        int n = dfp2.intValue();
        if (n > 0x7FFFFFFE) {
            return dfp.newInstance((byte)1, (byte)1);
        }
        if (n < -2147483646) {
            return dfp.newInstance();
        }
        Dfp dfp4 = DfpMath.splitPow(dfp.getField().getESplit(), n);
        Dfp dfp5 = DfpMath.expInternal(dfp3);
        return dfp4.multiply(dfp5);
    }

    protected static Dfp expInternal(Dfp dfp) {
        Dfp dfp2 = dfp.getOne();
        Dfp dfp3 = dfp.getOne();
        Dfp dfp4 = dfp.getOne();
        Dfp dfp5 = new Dfp(dfp2);
        for (int i = 1; i < 90 && !(dfp2 = dfp2.add((dfp3 = dfp3.multiply(dfp)).multiply(dfp4 = dfp4.divide(i)))).equals(dfp5); ++i) {
            dfp5 = new Dfp(dfp2);
        }
        return dfp2;
    }

    public static Dfp log(Dfp dfp) {
        int n = 0;
        if (dfp.equals(dfp.getZero()) || dfp.lessThan(dfp.getZero()) || dfp.isNaN()) {
            dfp.getField().setIEEEFlagsBits(1);
            return dfp.dotrap(1, "ln", dfp, dfp.newInstance((byte)1, (byte)3));
        }
        if (dfp.classify() == 1) {
            return dfp;
        }
        Dfp dfp2 = new Dfp(dfp);
        int n2 = dfp2.log10K();
        dfp2 = dfp2.divide(DfpMath.pow(dfp.newInstance(10000), n2));
        int n3 = dfp2.floor().intValue();
        while (n3 > 2) {
            n3 >>= 1;
            ++n;
        }
        Dfp[] dfpArray = DfpMath.split(dfp2);
        Dfp[] dfpArray2 = new Dfp[2];
        dfpArray2[0] = DfpMath.pow(dfp.getTwo(), n);
        dfpArray[0] = dfpArray[0].divide(dfpArray2[0]);
        dfpArray[1] = dfpArray[1].divide(dfpArray2[0]);
        dfpArray2[0] = dfp.newInstance("1.33333");
        while (dfpArray[0].add(dfpArray[1]).greaterThan(dfpArray2[0])) {
            dfpArray[0] = dfpArray[0].divide(2);
            dfpArray[1] = dfpArray[1].divide(2);
            ++n;
        }
        Dfp[] dfpArray3 = DfpMath.logInternal(dfpArray);
        dfpArray[0] = dfp.newInstance("" + (n + 4 * n2));
        dfpArray[1] = dfp.getZero();
        dfpArray2 = DfpMath.splitMult(dfp.getField().getLn2Split(), dfpArray);
        dfpArray3[0] = dfpArray3[0].add(dfpArray2[0]);
        dfpArray3[1] = dfpArray3[1].add(dfpArray2[1]);
        dfpArray[0] = dfp.newInstance("" + 4 * n2);
        dfpArray[1] = dfp.getZero();
        dfpArray2 = DfpMath.splitMult(dfp.getField().getLn5Split(), dfpArray);
        dfpArray3[0] = dfpArray3[0].add(dfpArray2[0]);
        dfpArray3[1] = dfpArray3[1].add(dfpArray2[1]);
        return dfp.newInstance(dfpArray3[0].add(dfpArray3[1]));
    }

    protected static Dfp[] logInternal(Dfp[] dfpArray) {
        Dfp dfp = dfpArray[0].divide(4).add(dfpArray[1].divide(4));
        Dfp dfp2 = dfp.add(dfpArray[0].newInstance("-0.25")).divide(dfp.add(dfpArray[0].newInstance("0.25")));
        Dfp dfp3 = new Dfp(dfp2);
        Dfp dfp4 = new Dfp(dfp2);
        Dfp dfp5 = new Dfp(dfp3);
        int n = 1;
        for (int i = 0; i < 10000; ++i) {
            dfp4 = dfp4.multiply(dfp2);
            dfp = (dfp4 = dfp4.multiply(dfp2)).divide(n += 2);
            if ((dfp3 = dfp3.add(dfp)).equals(dfp5)) break;
            dfp5 = new Dfp(dfp3);
        }
        dfp3 = dfp3.multiply(dfpArray[0].getTwo());
        return DfpMath.split(dfp3);
    }

    public static Dfp pow(Dfp dfp, Dfp dfp2) {
        Dfp dfp3;
        if (dfp.getField().getRadixDigits() != dfp2.getField().getRadixDigits()) {
            dfp.getField().setIEEEFlagsBits(1);
            Dfp dfp4 = dfp.newInstance(dfp.getZero());
            dfp4.nans = (byte)3;
            return dfp.dotrap(1, POW_TRAP, dfp, dfp4);
        }
        Dfp dfp5 = dfp.getZero();
        Dfp dfp6 = dfp.getOne();
        Dfp dfp7 = dfp.getTwo();
        boolean bl = false;
        if (dfp2.equals(dfp5)) {
            return dfp.newInstance(dfp6);
        }
        if (dfp2.equals(dfp6)) {
            if (dfp.isNaN()) {
                dfp.getField().setIEEEFlagsBits(1);
                return dfp.dotrap(1, POW_TRAP, dfp, dfp);
            }
            return dfp;
        }
        if (dfp.isNaN() || dfp2.isNaN()) {
            dfp.getField().setIEEEFlagsBits(1);
            return dfp.dotrap(1, POW_TRAP, dfp, dfp.newInstance((byte)1, (byte)3));
        }
        if (dfp.equals(dfp5)) {
            if (Dfp.copysign(dfp6, dfp).greaterThan(dfp5)) {
                if (dfp2.greaterThan(dfp5)) {
                    return dfp.newInstance(dfp5);
                }
                return dfp.newInstance(dfp.newInstance((byte)1, (byte)1));
            }
            if (dfp2.classify() == 0 && dfp2.rint().equals(dfp2) && !dfp2.remainder(dfp7).equals(dfp5)) {
                if (dfp2.greaterThan(dfp5)) {
                    return dfp.newInstance(dfp5.negate());
                }
                return dfp.newInstance(dfp.newInstance((byte)-1, (byte)1));
            }
            if (dfp2.greaterThan(dfp5)) {
                return dfp.newInstance(dfp5);
            }
            return dfp.newInstance(dfp.newInstance((byte)1, (byte)1));
        }
        if (dfp.lessThan(dfp5)) {
            dfp = dfp.negate();
            bl = true;
        }
        if (dfp.greaterThan(dfp6) && dfp2.classify() == 1) {
            if (dfp2.greaterThan(dfp5)) {
                return dfp2;
            }
            return dfp.newInstance(dfp5);
        }
        if (dfp.lessThan(dfp6) && dfp2.classify() == 1) {
            if (dfp2.greaterThan(dfp5)) {
                return dfp.newInstance(dfp5);
            }
            return dfp.newInstance(Dfp.copysign(dfp2, dfp6));
        }
        if (dfp.equals(dfp6) && dfp2.classify() == 1) {
            dfp.getField().setIEEEFlagsBits(1);
            return dfp.dotrap(1, POW_TRAP, dfp, dfp.newInstance((byte)1, (byte)3));
        }
        if (dfp.classify() == 1) {
            if (bl) {
                if (dfp2.classify() == 0 && dfp2.rint().equals(dfp2) && !dfp2.remainder(dfp7).equals(dfp5)) {
                    if (dfp2.greaterThan(dfp5)) {
                        return dfp.newInstance(dfp.newInstance((byte)-1, (byte)1));
                    }
                    return dfp.newInstance(dfp5.negate());
                }
                if (dfp2.greaterThan(dfp5)) {
                    return dfp.newInstance(dfp.newInstance((byte)1, (byte)1));
                }
                return dfp.newInstance(dfp5);
            }
            if (dfp2.greaterThan(dfp5)) {
                return dfp;
            }
            return dfp.newInstance(dfp5);
        }
        if (bl && !dfp2.rint().equals(dfp2)) {
            dfp.getField().setIEEEFlagsBits(1);
            return dfp.dotrap(1, POW_TRAP, dfp, dfp.newInstance((byte)1, (byte)3));
        }
        if (dfp2.lessThan(dfp.newInstance(100000000)) && dfp2.greaterThan(dfp.newInstance(-100000000))) {
            Dfp dfp8 = dfp2.rint();
            int n = dfp8.intValue();
            Dfp dfp9 = dfp2.subtract(dfp8);
            if (dfp9.unequal(dfp5)) {
                Dfp dfp10 = dfp9.multiply(DfpMath.log(dfp));
                Dfp dfp11 = dfp10.divide(dfp.getField().getLn2()).rint();
                Dfp dfp12 = dfp10.subtract(dfp11.multiply(dfp.getField().getLn2()));
                dfp3 = DfpMath.splitPow(DfpMath.split(dfp), n);
                dfp3 = dfp3.multiply(DfpMath.pow(dfp7, dfp11.intValue()));
                dfp3 = dfp3.multiply(DfpMath.exp(dfp12));
            } else {
                dfp3 = DfpMath.splitPow(DfpMath.split(dfp), n);
            }
        } else {
            dfp3 = DfpMath.exp(DfpMath.log(dfp).multiply(dfp2));
        }
        if (bl && dfp2.rint().equals(dfp2) && !dfp2.remainder(dfp7).equals(dfp5)) {
            dfp3 = dfp3.negate();
        }
        return dfp.newInstance(dfp3);
    }

    protected static Dfp sinInternal(Dfp[] dfpArray) {
        Dfp dfp;
        Dfp dfp2 = dfp = dfpArray[0].add(dfpArray[1]);
        dfp = dfp.multiply(dfp);
        Dfp dfp3 = dfp2;
        Dfp dfp4 = dfpArray[0].getOne();
        Dfp dfp5 = new Dfp(dfp2);
        for (int i = 3; i < 90; i += 2) {
            dfp3 = dfp3.multiply(dfp);
            if ((dfp2 = dfp2.add((dfp3 = dfp3.negate()).multiply(dfp4 = dfp4.divide((i - 1) * i)))).equals(dfp5)) break;
            dfp5 = new Dfp(dfp2);
        }
        return dfp2;
    }

    protected static Dfp cosInternal(Dfp[] dfpArray) {
        Dfp dfp;
        Dfp dfp2 = dfp = dfpArray[0].getOne();
        Dfp dfp3 = dfp;
        Dfp dfp4 = dfpArray[0].add(dfpArray[1]);
        dfp4 = dfp4.multiply(dfp4);
        Dfp dfp5 = dfp;
        Dfp dfp6 = new Dfp(dfp3);
        for (int i = 2; i < 90; i += 2) {
            dfp2 = dfp2.multiply(dfp4);
            if ((dfp3 = dfp3.add((dfp2 = dfp2.negate()).multiply(dfp5 = dfp5.divide((i - 1) * i)))).equals(dfp6)) break;
            dfp6 = new Dfp(dfp3);
        }
        return dfp3;
    }

    public static Dfp sin(Dfp dfp) {
        Dfp dfp2;
        Dfp dfp3 = dfp.getField().getPi();
        Dfp dfp4 = dfp.getField().getZero();
        boolean bl = false;
        Dfp dfp5 = dfp.remainder(dfp3.multiply(2));
        if (dfp5.lessThan(dfp4)) {
            dfp5 = dfp5.negate();
            bl = true;
        }
        if (dfp5.greaterThan(dfp3.divide(2))) {
            dfp5 = dfp3.subtract(dfp5);
        }
        if (dfp5.lessThan(dfp3.divide(4))) {
            dfp2 = DfpMath.sinInternal(DfpMath.split(dfp5));
        } else {
            Dfp[] dfpArray = new Dfp[2];
            Dfp[] dfpArray2 = dfp.getField().getPiSplit();
            dfpArray[0] = dfpArray2[0].divide(2).subtract(dfp5);
            dfpArray[1] = dfpArray2[1].divide(2);
            dfp2 = DfpMath.cosInternal(dfpArray);
        }
        if (bl) {
            dfp2 = dfp2.negate();
        }
        return dfp.newInstance(dfp2);
    }

    public static Dfp cos(Dfp dfp) {
        Dfp dfp2;
        Dfp dfp3 = dfp.getField().getPi();
        Dfp dfp4 = dfp.getField().getZero();
        boolean bl = false;
        Dfp dfp5 = dfp.remainder(dfp3.multiply(2));
        if (dfp5.lessThan(dfp4)) {
            dfp5 = dfp5.negate();
        }
        if (dfp5.greaterThan(dfp3.divide(2))) {
            dfp5 = dfp3.subtract(dfp5);
            bl = true;
        }
        if (dfp5.lessThan(dfp3.divide(4))) {
            Dfp[] dfpArray = new Dfp[]{dfp5, dfp4};
            dfp2 = DfpMath.cosInternal(dfpArray);
        } else {
            Dfp[] dfpArray = new Dfp[2];
            Dfp[] dfpArray2 = dfp.getField().getPiSplit();
            dfpArray[0] = dfpArray2[0].divide(2).subtract(dfp5);
            dfpArray[1] = dfpArray2[1].divide(2);
            dfp2 = DfpMath.sinInternal(dfpArray);
        }
        if (bl) {
            dfp2 = dfp2.negate();
        }
        return dfp.newInstance(dfp2);
    }

    public static Dfp tan(Dfp dfp) {
        return DfpMath.sin(dfp).divide(DfpMath.cos(dfp));
    }

    protected static Dfp atanInternal(Dfp dfp) {
        Dfp dfp2 = new Dfp(dfp);
        Dfp dfp3 = new Dfp(dfp2);
        Dfp dfp4 = new Dfp(dfp2);
        for (int i = 3; i < 90; i += 2) {
            dfp3 = dfp3.multiply(dfp);
            dfp3 = dfp3.multiply(dfp);
            if ((dfp2 = dfp2.add((dfp3 = dfp3.negate()).divide(i))).equals(dfp4)) break;
            dfp4 = new Dfp(dfp2);
        }
        return dfp2;
    }

    public static Dfp atan(Dfp dfp) {
        Object object;
        Dfp dfp2 = dfp.getField().getZero();
        Dfp dfp3 = dfp.getField().getOne();
        Dfp[] dfpArray = dfp.getField().getSqr2Split();
        Dfp[] dfpArray2 = dfp.getField().getPiSplit();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Dfp dfp4 = dfpArray[0].subtract(dfp3).add(dfpArray[1]);
        Dfp dfp5 = new Dfp(dfp);
        if (dfp5.lessThan(dfp2)) {
            bl2 = true;
            dfp5 = dfp5.negate();
        }
        if (dfp5.greaterThan(dfp3)) {
            bl = true;
            dfp5 = dfp3.divide(dfp5);
        }
        if (dfp5.greaterThan(dfp4)) {
            object = new Dfp[2];
            bl3 = true;
            object[0] = dfpArray[0].subtract(dfp3);
            object[1] = dfpArray[1];
            Dfp[] dfpArray3 = DfpMath.split(dfp5);
            Dfp[] dfpArray4 = DfpMath.splitMult(dfpArray3, (Dfp[])object);
            dfpArray4[0] = dfpArray4[0].add(dfp3);
            dfpArray3[0] = dfpArray3[0].subtract((Dfp)object[0]);
            dfpArray3[1] = dfpArray3[1].subtract((Dfp)object[1]);
            dfpArray3 = DfpMath.splitDiv(dfpArray3, dfpArray4);
            dfp5 = dfpArray3[0].add(dfpArray3[1]);
        }
        object = DfpMath.atanInternal(dfp5);
        if (bl3) {
            object = ((Dfp)object).add(dfpArray2[0].divide(8)).add(dfpArray2[1].divide(8));
        }
        if (bl) {
            object = dfpArray2[0].divide(2).subtract((Dfp)object).add(dfpArray2[1].divide(2));
        }
        if (bl2) {
            object = ((Dfp)object).negate();
        }
        return dfp.newInstance((Dfp)object);
    }

    public static Dfp asin(Dfp dfp) {
        return DfpMath.atan(dfp.divide(dfp.getOne().subtract(dfp.multiply(dfp)).sqrt()));
    }

    public static Dfp acos(Dfp dfp) {
        boolean bl = false;
        if (dfp.lessThan(dfp.getZero())) {
            bl = true;
        }
        dfp = Dfp.copysign(dfp, dfp.getOne());
        Dfp dfp2 = DfpMath.atan(dfp.getOne().subtract(dfp.multiply(dfp)).sqrt().divide(dfp));
        if (bl) {
            dfp2 = dfp.getField().getPi().subtract(dfp2);
        }
        return dfp.newInstance(dfp2);
    }
}

