/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.MultivariateRealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;

public abstract class AbstractMultivariateRealDistribution
implements MultivariateRealDistribution {
    protected final RandomGenerator random;
    private final int dimension;

    protected AbstractMultivariateRealDistribution(RandomGenerator randomGenerator, int n) {
        this.random = randomGenerator;
        this.dimension = n;
    }

    public void reseedRandomGenerator(long l) {
        this.random.setSeed(l);
    }

    public int getDimension() {
        return this.dimension;
    }

    public abstract double[] sample();

    public double[][] sample(int n) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, n);
        }
        double[][] dArray = new double[n][this.dimension];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.sample();
        }
        return dArray;
    }
}

