/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.EnumeratedDistribution;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumeratedRealDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20130308L;
    protected final EnumeratedDistribution<Double> innerDistribution;

    public EnumeratedRealDistribution(double[] dArray, double[] dArray2) {
        this(new Well19937c(), dArray, dArray2);
    }

    public EnumeratedRealDistribution(RandomGenerator randomGenerator, double[] dArray, double[] dArray2) {
        super(randomGenerator);
        this.innerDistribution = new EnumeratedDistribution(randomGenerator, EnumeratedRealDistribution.createDistribution(dArray, dArray2));
    }

    public EnumeratedRealDistribution(RandomGenerator randomGenerator, double[] dArray) {
        super(randomGenerator);
        HashMap<Double, Integer> hashMap = new HashMap<Double, Integer>();
        for (double d : dArray) {
            Integer n = (Integer)hashMap.get(d);
            if (n == null) {
                n = 0;
            }
            n = n + 1;
            hashMap.put(d, n);
        }
        int n = hashMap.size();
        double d = dArray.length;
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        int n2 = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            dArray2[n2] = (Double)entry.getKey();
            dArray3[n2] = (double)((Integer)entry.getValue()).intValue() / d;
            ++n2;
        }
        this.innerDistribution = new EnumeratedDistribution(randomGenerator, EnumeratedRealDistribution.createDistribution(dArray2, dArray3));
    }

    public EnumeratedRealDistribution(double[] dArray) {
        this(new Well19937c(), dArray);
    }

    private static List<Pair<Double, Double>> createDistribution(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray2.length, dArray.length);
        }
        ArrayList<Pair<Double, Double>> arrayList = new ArrayList<Pair<Double, Double>>(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            arrayList.add(new Pair<Double, Double>(dArray[i], dArray2[i]));
        }
        return arrayList;
    }

    @Override
    public double probability(double d) {
        return this.innerDistribution.probability(d);
    }

    @Override
    public double density(double d) {
        return this.probability(d);
    }

    @Override
    public double cumulativeProbability(double d) {
        double d2 = 0.0;
        for (Pair<Double, Double> pair : this.innerDistribution.getPmf()) {
            if (!(pair.getKey() <= d)) continue;
            d2 += pair.getValue().doubleValue();
        }
        return d2;
    }

    @Override
    public double inverseCumulativeProbability(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException(d, (Number)0, 1);
        }
        double d2 = 0.0;
        double d3 = this.getSupportLowerBound();
        for (Pair<Double, Double> pair : this.innerDistribution.getPmf()) {
            if (pair.getValue() == 0.0) continue;
            d2 += pair.getValue().doubleValue();
            d3 = pair.getKey();
            if (!(d2 >= d)) continue;
            break;
        }
        return d3;
    }

    @Override
    public double getNumericalMean() {
        double d = 0.0;
        for (Pair<Double, Double> pair : this.innerDistribution.getPmf()) {
            d += pair.getValue() * pair.getKey();
        }
        return d;
    }

    @Override
    public double getNumericalVariance() {
        double d = 0.0;
        double d2 = 0.0;
        for (Pair<Double, Double> pair : this.innerDistribution.getPmf()) {
            d += pair.getValue() * pair.getKey();
            d2 += pair.getValue() * pair.getKey() * pair.getKey();
        }
        return d2 - d * d;
    }

    @Override
    public double getSupportLowerBound() {
        double d = Double.POSITIVE_INFINITY;
        for (Pair<Double, Double> pair : this.innerDistribution.getPmf()) {
            if (!(pair.getKey() < d) || !(pair.getValue() > 0.0)) continue;
            d = pair.getKey();
        }
        return d;
    }

    @Override
    public double getSupportUpperBound() {
        double d = Double.NEGATIVE_INFINITY;
        for (Pair<Double, Double> pair : this.innerDistribution.getPmf()) {
            if (!(pair.getKey() > d) || !(pair.getValue() > 0.0)) continue;
            d = pair.getKey();
        }
        return d;
    }

    @Override
    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    @Override
    public boolean isSupportUpperBoundInclusive() {
        return true;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public double sample() {
        return this.innerDistribution.sample();
    }
}

