/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.FastMath;

public class LaplaceDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20141003L;
    private final double mu;
    private final double beta;

    public LaplaceDistribution(double d, double d2) {
        this(new Well19937c(), d, d2);
    }

    public LaplaceDistribution(RandomGenerator randomGenerator, double d, double d2) {
        super(randomGenerator);
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NOT_POSITIVE_SCALE, d2);
        }
        this.mu = d;
        this.beta = d2;
    }

    public double getLocation() {
        return this.mu;
    }

    public double getScale() {
        return this.beta;
    }

    public double density(double d) {
        return FastMath.exp(-FastMath.abs(d - this.mu) / this.beta) / (2.0 * this.beta);
    }

    public double cumulativeProbability(double d) {
        if (d <= this.mu) {
            return FastMath.exp((d - this.mu) / this.beta) / 2.0;
        }
        return 1.0 - FastMath.exp((this.mu - d) / this.beta) / 2.0;
    }

    public double inverseCumulativeProbability(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException(d, (Number)0.0, 1.0);
        }
        if (d == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double d2 = d > 0.5 ? -Math.log(2.0 - 2.0 * d) : Math.log(2.0 * d);
        return this.mu + this.beta * d2;
    }

    public double getNumericalMean() {
        return this.mu;
    }

    public double getNumericalVariance() {
        return 2.0 * this.beta * this.beta;
    }

    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return false;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }
}

