/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.distribution.AbstractMultivariateRealDistribution;
import org.apache.commons.math3.distribution.MultivariateRealDistribution;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MixtureMultivariateRealDistribution<T extends MultivariateRealDistribution>
extends AbstractMultivariateRealDistribution {
    private final double[] weight;
    private final List<T> distribution;

    public MixtureMultivariateRealDistribution(List<Pair<Double, T>> list) {
        this((RandomGenerator)new Well19937c(), list);
    }

    public MixtureMultivariateRealDistribution(RandomGenerator randomGenerator, List<Pair<Double, T>> list) {
        super(randomGenerator, ((MultivariateRealDistribution)list.get(0).getSecond()).getDimension());
        Pair<Double, T> pair;
        int n;
        int n2 = list.size();
        int n3 = this.getDimension();
        double d = 0.0;
        for (n = 0; n < n2; ++n) {
            pair = list.get(n);
            if (((MultivariateRealDistribution)pair.getSecond()).getDimension() != n3) {
                throw new DimensionMismatchException(((MultivariateRealDistribution)pair.getSecond()).getDimension(), n3);
            }
            if (pair.getFirst() < 0.0) {
                throw new NotPositiveException(pair.getFirst());
            }
            d += pair.getFirst().doubleValue();
        }
        if (Double.isInfinite(d)) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        this.distribution = new ArrayList<T>();
        this.weight = new double[n2];
        for (n = 0; n < n2; ++n) {
            pair = list.get(n);
            this.weight[n] = pair.getFirst() / d;
            this.distribution.add(pair.getSecond());
        }
    }

    @Override
    public double density(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < this.weight.length; ++i) {
            d += this.weight[i] * ((MultivariateRealDistribution)this.distribution.get(i)).density(dArray);
        }
        return d;
    }

    @Override
    public double[] sample() {
        double[] dArray = null;
        double d = this.random.nextDouble();
        double d2 = 0.0;
        for (int i = 0; i < this.weight.length; ++i) {
            if (!(d <= (d2 += this.weight[i]))) continue;
            dArray = ((MultivariateRealDistribution)this.distribution.get(i)).sample();
            break;
        }
        if (dArray == null) {
            dArray = ((MultivariateRealDistribution)this.distribution.get(this.weight.length - 1)).sample();
        }
        return dArray;
    }

    @Override
    public void reseedRandomGenerator(long l) {
        super.reseedRandomGenerator(l);
        for (int i = 0; i < this.distribution.size(); ++i) {
            ((MultivariateRealDistribution)this.distribution.get(i)).reseedRandomGenerator((long)(i + 1) + l);
        }
    }

    public List<Pair<Double, T>> getComponents() {
        ArrayList<Pair<Double, T>> arrayList = new ArrayList<Pair<Double, T>>(this.weight.length);
        for (int i = 0; i < this.weight.length; ++i) {
            arrayList.add(new Pair<Double, T>(this.weight[i], this.distribution.get(i)));
        }
        return arrayList;
    }
}

