/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractMultivariateRealDistribution;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.NonPositiveDefiniteMatrixException;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

public class MultivariateNormalDistribution
extends AbstractMultivariateRealDistribution {
    private final double[] means;
    private final RealMatrix covarianceMatrix;
    private final RealMatrix covarianceMatrixInverse;
    private final double covarianceMatrixDeterminant;
    private final RealMatrix samplingMatrix;

    public MultivariateNormalDistribution(double[] dArray, double[][] dArray2) {
        this(new Well19937c(), dArray, dArray2);
    }

    public MultivariateNormalDistribution(RandomGenerator randomGenerator, double[] dArray, double[][] dArray2) {
        super(randomGenerator, dArray.length);
        int n = dArray.length;
        if (dArray2.length != n) {
            throw new DimensionMismatchException(dArray2.length, n);
        }
        for (int i = 0; i < n; ++i) {
            if (n == dArray2[i].length) continue;
            throw new DimensionMismatchException(dArray2[i].length, n);
        }
        this.means = MathArrays.copyOf(dArray);
        this.covarianceMatrix = new Array2DRowRealMatrix(dArray2);
        EigenDecomposition eigenDecomposition = new EigenDecomposition(this.covarianceMatrix);
        this.covarianceMatrixInverse = eigenDecomposition.getSolver().getInverse();
        this.covarianceMatrixDeterminant = eigenDecomposition.getDeterminant();
        double[] dArray3 = eigenDecomposition.getRealEigenvalues();
        for (int i = 0; i < dArray3.length; ++i) {
            if (!(dArray3[i] < 0.0)) continue;
            throw new NonPositiveDefiniteMatrixException(dArray3[i], i, 0.0);
        }
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(n, n);
        for (int i = 0; i < n; ++i) {
            double[] dArray4 = eigenDecomposition.getEigenvector(i).toArray();
            array2DRowRealMatrix.setColumn(i, dArray4);
        }
        RealMatrix realMatrix = array2DRowRealMatrix.transpose();
        for (int i = 0; i < n; ++i) {
            double d = FastMath.sqrt(dArray3[i]);
            for (int j = 0; j < n; ++j) {
                realMatrix.multiplyEntry(i, j, d);
            }
        }
        this.samplingMatrix = array2DRowRealMatrix.multiply(realMatrix);
    }

    public double[] getMeans() {
        return MathArrays.copyOf(this.means);
    }

    public RealMatrix getCovariances() {
        return this.covarianceMatrix.copy();
    }

    public double density(double[] dArray) {
        int n = this.getDimension();
        if (dArray.length != n) {
            throw new DimensionMismatchException(dArray.length, n);
        }
        return FastMath.pow(Math.PI * 2, -0.5 * (double)n) * FastMath.pow(this.covarianceMatrixDeterminant, -0.5) * this.getExponentTerm(dArray);
    }

    public double[] getStandardDeviations() {
        int n = this.getDimension();
        double[] dArray = new double[n];
        double[][] dArray2 = this.covarianceMatrix.getData();
        for (int i = 0; i < n; ++i) {
            dArray[i] = FastMath.sqrt(dArray2[i][i]);
        }
        return dArray;
    }

    public double[] sample() {
        int n = this.getDimension();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.random.nextGaussian();
        }
        double[] dArray2 = this.samplingMatrix.operate(dArray);
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            dArray2[n2] = dArray2[n2] + this.means[i];
        }
        return dArray2;
    }

    private double getExponentTerm(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[i] - this.getMeans()[i];
        }
        double[] dArray3 = this.covarianceMatrixInverse.preMultiply(dArray2);
        double d = 0.0;
        for (int i = 0; i < dArray3.length; ++i) {
            d += dArray3[i] * dArray2[i];
        }
        return FastMath.exp(-0.5 * d);
    }
}

