/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.FastMath;

public class TriangularDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20120112L;
    private final double a;
    private final double b;
    private final double c;
    private final double solverAbsoluteAccuracy;

    public TriangularDistribution(double d, double d2, double d3) {
        this(new Well19937c(), d, d2, d3);
    }

    public TriangularDistribution(RandomGenerator randomGenerator, double d, double d2, double d3) {
        super(randomGenerator);
        if (d >= d3) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)d, d3, false);
        }
        if (d2 < d) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NUMBER_TOO_SMALL, (Number)d2, d, true);
        }
        if (d2 > d3) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.NUMBER_TOO_LARGE, (Number)d2, d3, true);
        }
        this.a = d;
        this.c = d2;
        this.b = d3;
        this.solverAbsoluteAccuracy = FastMath.max(FastMath.ulp(d), FastMath.ulp(d3));
    }

    public double getMode() {
        return this.c;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public double density(double d) {
        if (d < this.a) {
            return 0.0;
        }
        if (this.a <= d && d < this.c) {
            double d2 = 2.0 * (d - this.a);
            double d3 = (this.b - this.a) * (this.c - this.a);
            return d2 / d3;
        }
        if (d == this.c) {
            return 2.0 / (this.b - this.a);
        }
        if (this.c < d && d <= this.b) {
            double d4 = 2.0 * (this.b - d);
            double d5 = (this.b - this.a) * (this.b - this.c);
            return d4 / d5;
        }
        return 0.0;
    }

    public double cumulativeProbability(double d) {
        if (d < this.a) {
            return 0.0;
        }
        if (this.a <= d && d < this.c) {
            double d2 = (d - this.a) * (d - this.a);
            double d3 = (this.b - this.a) * (this.c - this.a);
            return d2 / d3;
        }
        if (d == this.c) {
            return (this.c - this.a) / (this.b - this.a);
        }
        if (this.c < d && d <= this.b) {
            double d4 = (this.b - d) * (this.b - d);
            double d5 = (this.b - this.a) * (this.b - this.c);
            return 1.0 - d4 / d5;
        }
        return 1.0;
    }

    public double getNumericalMean() {
        return (this.a + this.b + this.c) / 3.0;
    }

    public double getNumericalVariance() {
        return (this.a * this.a + this.b * this.b + this.c * this.c - this.a * this.b - this.a * this.c - this.b * this.c) / 18.0;
    }

    public double getSupportLowerBound() {
        return this.a;
    }

    public double getSupportUpperBound() {
        return this.b;
    }

    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public boolean isSupportUpperBoundInclusive() {
        return true;
    }

    public boolean isSupportConnected() {
        return true;
    }

    public double inverseCumulativeProbability(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException(d, (Number)0, 1);
        }
        if (d == 0.0) {
            return this.a;
        }
        if (d == 1.0) {
            return this.b;
        }
        if (d < (this.c - this.a) / (this.b - this.a)) {
            return this.a + FastMath.sqrt(d * (this.b - this.a) * (this.c - this.a));
        }
        return this.b - FastMath.sqrt((1.0 - d) * (this.b - this.a) * (this.b - this.c));
    }
}

