/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;

public class UniformRealDistribution
extends AbstractRealDistribution {
    @Deprecated
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 20120109L;
    private final double lower;
    private final double upper;

    public UniformRealDistribution() {
        this(0.0, 1.0);
    }

    public UniformRealDistribution(double d, double d2) {
        this(new Well19937c(), d, d2);
    }

    @Deprecated
    public UniformRealDistribution(double d, double d2, double d3) {
        this(new Well19937c(), d, d2);
    }

    @Deprecated
    public UniformRealDistribution(RandomGenerator randomGenerator, double d, double d2, double d3) {
        this(randomGenerator, d, d2);
    }

    public UniformRealDistribution(RandomGenerator randomGenerator, double d, double d2) {
        super(randomGenerator);
        if (d >= d2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)d, d2, false);
        }
        this.lower = d;
        this.upper = d2;
    }

    public double density(double d) {
        if (d < this.lower || d > this.upper) {
            return 0.0;
        }
        return 1.0 / (this.upper - this.lower);
    }

    public double cumulativeProbability(double d) {
        if (d <= this.lower) {
            return 0.0;
        }
        if (d >= this.upper) {
            return 1.0;
        }
        return (d - this.lower) / (this.upper - this.lower);
    }

    public double inverseCumulativeProbability(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException(d, (Number)0, 1);
        }
        return d * (this.upper - this.lower) + this.lower;
    }

    public double getNumericalMean() {
        return 0.5 * (this.lower + this.upper);
    }

    public double getNumericalVariance() {
        double d = this.upper - this.lower;
        return d * d / 12.0;
    }

    public double getSupportLowerBound() {
        return this.lower;
    }

    public double getSupportUpperBound() {
        return this.upper;
    }

    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public boolean isSupportUpperBoundInclusive() {
        return true;
    }

    public boolean isSupportConnected() {
        return true;
    }

    public double sample() {
        double d = this.random.nextDouble();
        return d * this.upper + (1.0 - d) * this.lower;
    }
}

